/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import org.scijava.util.GenericUtils;

public class ConversionRequest {
    private final Type srcType;
    private final Type destType;
    private Object src;

    public ConversionRequest(Object src, Type destType) {
        this(src, src == null ? null : src.getClass(), destType);
    }

    public ConversionRequest(Type srcType, Type destType) {
        this(null, srcType, destType);
    }

    public ConversionRequest(Object src, Type srcType, Type destType) {
        this.src = src;
        this.srcType = srcType;
        this.destType = destType;
    }

    public Type sourceType() {
        return this.srcType;
    }

    public Class<?> sourceClass() {
        return GenericUtils.getClass(this.srcType);
    }

    public Object sourceObject() {
        return this.src;
    }

    public Type destType() {
        return this.destType;
    }

    public Class<?> destClass() {
        return GenericUtils.getClass(this.destType);
    }

    public void setSourceObject(Object o) {
        if (!this.sourceClass().isInstance(o)) {
            throw new IllegalArgumentException("Object of type: " + o.getClass() + " provided. Expected: " + this.srcType);
        }
        this.src = o;
    }
}

