/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.main;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.scijava.log.LogService;
import org.scijava.main.MainService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.ClassUtils;

@Plugin(type=Service.class)
public class DefaultMainService
extends AbstractService
implements MainService {
    @Parameter(required=false)
    private LogService log;
    private final List<MainService.Main> mains = new ArrayList<MainService.Main>();

    @Override
    public int execMains() {
        int mainCount = 0;
        for (MainService.Main main : this.mains) {
            main.exec();
            ++mainCount;
        }
        return mainCount;
    }

    @Override
    public void addMain(String className, String ... args) {
        this.mains.add(new DefaultMain(className, args));
    }

    @Override
    public MainService.Main[] getMains() {
        return this.mains.toArray(new MainService.Main[this.mains.size()]);
    }

    private class DefaultMain
    implements MainService.Main {
        private String className;
        private String[] args;

        public DefaultMain(String className, String ... args) {
            this.className = className;
            this.args = (String[])args.clone();
        }

        @Override
        public String className() {
            return this.className;
        }

        @Override
        public String[] args() {
            return this.args;
        }

        @Override
        public void exec() {
            block6: {
                try {
                    Class<?> mainClass = ClassUtils.loadClass(this.className);
                    Method main = mainClass.getMethod("main", String[].class);
                    main.invoke(null, new Object[]{this.args});
                }
                catch (NoSuchMethodException exc) {
                    if (DefaultMainService.this.log != null) {
                        DefaultMainService.this.log.error("No main method for class: " + this.className, exc);
                    }
                }
                catch (IllegalAccessException exc) {
                    if (DefaultMainService.this.log != null) {
                        DefaultMainService.this.log.error(exc);
                    }
                }
                catch (InvocationTargetException exc) {
                    if (DefaultMainService.this.log == null) break block6;
                    DefaultMainService.this.log.error(exc);
                }
            }
        }
    }
}

