/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public final class GenericUtils {
    private GenericUtils() {
    }

    public static Class<?> getClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        List<Class<?>> c = GenericUtils.getClasses(type);
        if (c == null || c.size() != 1) {
            return null;
        }
        return c.get(0);
    }

    public static List<Class<?>> getClasses(Type type) {
        if (type == null) {
            return null;
        }
        return GenericTypeReflector.getUpperBoundClassAndInterfaces((Type)type);
    }

    public static Type getComponentType(Type type) {
        return GenericTypeReflector.getArrayComponentType((Type)type);
    }

    public static Class<?> getComponentClass(Type type) {
        return GenericUtils.getClass(GenericUtils.getComponentType(type));
    }

    public static Type getFieldType(Field field, Class<?> type) {
        Type wildType = GenericTypeReflector.addWildcardParameters(type);
        return GenericTypeReflector.getExactFieldType((Field)field, (Type)wildType);
    }

    public static List<Class<?>> getFieldClasses(Field field, Class<?> type) {
        Type genericType = GenericUtils.getFieldType(field, type);
        return GenericUtils.getClasses(genericType);
    }

    public static Type getMethodReturnType(Method method, Class<?> type) {
        Type wildType = GenericTypeReflector.addWildcardParameters(type);
        return GenericTypeReflector.getExactReturnType((Method)method, (Type)wildType);
    }

    public static List<Class<?>> getMethodReturnClasses(Method method, Class<?> type) {
        Type genericType = GenericUtils.getMethodReturnType(method, type);
        return GenericUtils.getClasses(genericType);
    }

    public static Type getTypeParameter(Type type, Class<?> c, int paramNo) {
        return GenericTypeReflector.getTypeParameter((Type)type, c.getTypeParameters()[paramNo]);
    }
}

