/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.text.DecimalFormatSymbols;

public final class StringUtils {
    private StringUtils() {
    }

    public static String sanitizeDouble(String value) {
        value = value.replaceAll("[^0-9,\\.]", "");
        char separator = new DecimalFormatSymbols().getDecimalSeparator();
        char usedSeparator = separator == '.' ? (char)',' : '.';
        value = value.replace(usedSeparator, separator);
        try {
            Double.parseDouble(value);
        }
        catch (Exception e) {
            value = value.replace(separator, usedSeparator);
        }
        return value;
    }

    public static String stripNulls(String toStrip) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < toStrip.length(); ++i) {
            if (toStrip.charAt(i) == '\u0000') continue;
            s.append(toStrip.charAt(i));
        }
        return s.toString().trim();
    }

    public static boolean samePrefix(String s1, String s2) {
        String sub2;
        if (s1 == null || s2 == null) {
            return false;
        }
        int n1 = s1.indexOf(".");
        int n2 = s2.indexOf(".");
        if (n1 == -1 || n2 == -1) {
            return false;
        }
        int slash1 = s1.lastIndexOf(File.pathSeparator);
        int slash2 = s2.lastIndexOf(File.pathSeparator);
        String sub1 = s1.substring(slash1 + 1, n1);
        return sub1.equals(sub2 = s2.substring(slash2 + 1, n2)) || sub1.startsWith(sub2) || sub2.startsWith(sub1);
    }

    public static String sanitize(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(s);
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c == '\t' || c == '\n' || c >= ' ' && c <= '~') continue;
            buf = buf.deleteCharAt(i--);
        }
        return buf.toString();
    }
}

