/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.widget;

import java.util.HashMap;
import java.util.Map;
import org.scijava.widget.InputPanel;
import org.scijava.widget.InputWidget;

public abstract class AbstractInputPanel<P, W>
implements InputPanel<P, W> {
    protected Map<String, InputWidget<?, W>> widgets = new HashMap();

    @Override
    public boolean supports(InputWidget<?, ?> widget) {
        Class thisType = this.getWidgetComponentType();
        Class thatType = widget.getComponentType();
        return thisType.isAssignableFrom(thatType);
    }

    @Override
    public void addWidget(InputWidget<?, W> widget) {
        this.widgets.put(widget.get().getItem().getName(), widget);
    }

    @Override
    public InputWidget<?, W> getWidget(String name) {
        return this.widgets.get(name);
    }

    @Override
    public Object getValue(String name) {
        return this.widgets.get(name).getValue();
    }

    @Override
    public int getWidgetCount() {
        return this.widgets.size();
    }

    @Override
    public boolean hasWidgets() {
        return this.widgets.size() > 0;
    }

    @Override
    public boolean isMessageOnly() {
        int messageCount = 0;
        for (InputWidget<?, W> widget : this.widgets.values()) {
            if (!widget.isMessage()) continue;
            ++messageCount;
        }
        return messageCount == this.getWidgetCount();
    }

    @Override
    public void refresh() {
        for (InputWidget<?, W> w : this.widgets.values()) {
            w.refreshWidget();
        }
    }
}

