/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.app;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.app.event.StatusEvent;
import org.scijava.event.EventHandler;
import org.scijava.plugin.Parameter;

public class StatusServiceTest {
    private Context context;
    private StatusListener statusListener;
    private BlockingQueue<StatusEvent> queue;
    private StatusService ss;

    @Before
    public void setUp() {
        this.context = new Context();
        this.queue = new ArrayBlockingQueue<StatusEvent>(10);
        this.statusListener = new StatusListener();
        this.statusListener.setContext(this.context);
        this.ss = this.statusListener.statusService;
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testShowProgress() throws InterruptedException {
        this.ss.showProgress(15, 45);
        StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)event.getProgressValue(), (long)15L);
        Assert.assertEquals((long)event.getProgressMaximum(), (long)45L);
        Assert.assertFalse((boolean)event.isWarning());
    }

    @Test
    public void testShowStatusString() throws InterruptedException {
        String text = "Hello, world";
        this.ss.showStatus("Hello, world");
        StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)event.getStatusMessage(), (Object)"Hello, world");
        Assert.assertFalse((boolean)event.isWarning());
    }

    @Test
    public void testShowStatusIntIntString() throws InterruptedException {
        String text = "Working...";
        this.ss.showStatus(25, 55, "Working...");
        StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)event.getProgressValue(), (long)25L);
        Assert.assertEquals((long)event.getProgressMaximum(), (long)55L);
        Assert.assertEquals((Object)event.getStatusMessage(), (Object)"Working...");
        Assert.assertFalse((boolean)event.isWarning());
    }

    @Test
    public void testWarn() throws InterruptedException {
        String text = "Totally hosed";
        this.ss.warn("Totally hosed");
        StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)event.getStatusMessage(), (Object)"Totally hosed");
        Assert.assertTrue((boolean)event.isWarning());
    }

    @Test
    public void testShowStatusIntIntStringBoolean() throws InterruptedException {
        String text = "Working and hosed...";
        this.ss.showStatus(33, 44, "Working and hosed...", true);
        StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)event.getStatusMessage(), (Object)"Working and hosed...");
        Assert.assertEquals((long)event.getProgressValue(), (long)33L);
        Assert.assertEquals((long)event.getProgressMaximum(), (long)44L);
        Assert.assertTrue((boolean)event.isWarning());
    }

    @Test
    public void testClearStatus() throws InterruptedException {
        this.ss.clearStatus();
        StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)event.getStatusMessage(), (Object)"");
        Assert.assertFalse((boolean)event.isWarning());
    }

    private class StatusListener
    extends AbstractContextual {
        @Parameter
        private StatusService statusService;

        private StatusListener() {
        }

        @EventHandler
        private void eventHandler(StatusEvent e) {
            try {
                StatusServiceTest.this.queue.put(new StatusEvent(e.getProgressValue(), e.getProgressMaximum(), e.getStatusMessage(), e.isWarning()));
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                Assert.fail();
            }
        }
    }
}

