/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.plugin.AbstractRichPlugin;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.plugin.SingletonPlugin;

public class SingletonServiceTest {
    @Test
    public void testListenToRemove() {
        Context ctx = new Context(new Class[]{PluginService.class, DummySingletonService.class, DummySingletonService2.class});
        DummySingletonService dss = (DummySingletonService)ctx.getService(DummySingletonService.class);
        DummySingletonService2 dss2 = (DummySingletonService2)ctx.getService(DummySingletonService2.class);
        List instances = dss.getInstances();
        DummyPlugin dummy = (DummyPlugin)((Object)instances.get(0));
        Assert.assertFalse((String)"Service not correctly initialized", (boolean)dss2.getInstances().isEmpty());
        PluginService ps = (PluginService)ctx.getService(PluginService.class);
        ps.removePlugin(dummy.getInfo());
        Assert.assertFalse((String)"Plugin was removed from wrong service!", (boolean)dss2.getInstances().isEmpty());
        Assert.assertTrue((String)"Plugin was not removed!", (boolean)dss.getInstances().isEmpty());
        ps.addPlugin(dummy.getInfo());
        Assert.assertEquals((String)"Wrong number of plugins in service:", (long)1L, (long)dss.getInstances().size());
        Assert.assertEquals((String)"Wrong number of plugins in independent service:", (long)1L, (long)dss2.getInstances().size());
    }

    public static class DummySingletonService2
    extends AbstractSingletonService<DummyPlugin2> {
        public Class<DummyPlugin2> getPluginType() {
            return DummyPlugin2.class;
        }
    }

    @Plugin(type=DummyPlugin2.class)
    public static class DummyPlugin2
    extends AbstractRichPlugin
    implements SingletonPlugin {
    }

    public static class DummySingletonService
    extends AbstractSingletonService<DummyPlugin> {
        public Class<DummyPlugin> getPluginType() {
            return DummyPlugin.class;
        }
    }

    @Plugin(type=DummyPlugin.class)
    public static class DummyPlugin
    extends AbstractRichPlugin
    implements SingletonPlugin {
    }
}

