/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.run;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.plugin.Plugin;
import org.scijava.run.AbstractCodeRunner;
import org.scijava.run.CodeRunner;
import org.scijava.run.RunService;

public class RunServiceTest {
    private RunService runService;

    @Before
    public void setUp() {
        this.runService = (RunService)new Context().service(RunService.class);
    }

    @After
    public void tearDown() {
        this.runService.context().dispose();
    }

    @Test
    public void testRunList() throws InvocationTargetException {
        StringBuilder sb = new StringBuilder();
        this.runService.run((Object)sb, new Object[]{"foo", "bar", "fu bar"});
        Assert.assertEquals((Object)"|foo|bar|fu bar|", (Object)sb.toString());
    }

    @Test
    public void testRunMap() throws InvocationTargetException {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, Object> inputMap = new LinkedHashMap<String, Object>();
        inputMap.put("foo", "bar");
        inputMap.put("animal", "quick brown fox");
        inputMap.put("number", 33);
        this.runService.run((Object)sb, inputMap);
        Assert.assertEquals((Object)"|foo=bar|animal=quick brown fox|number=33|", (Object)sb.toString());
    }

    @Plugin(type=CodeRunner.class)
    public static class StringRunner
    extends AbstractCodeRunner {
        public void run(Object code, Object ... args) throws InvocationTargetException {
            StringBuilder sb = this.getStringBuilder(code);
            sb.append("|");
            for (Object arg : args) {
                sb.append(arg);
                sb.append("|");
            }
        }

        public void run(Object code, Map<String, Object> inputMap) throws InvocationTargetException {
            StringBuilder sb = this.getStringBuilder(code);
            sb.append("|");
            for (String key : inputMap.keySet()) {
                sb.append(key);
                sb.append("=");
                sb.append(inputMap.get(key));
                sb.append("|");
            }
        }

        public boolean supports(Object code) {
            return this.getStringBuilder(code) != null;
        }

        private StringBuilder getStringBuilder(Object code) {
            return code instanceof StringBuilder ? (StringBuilder)code : null;
        }
    }
}

