/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.plugin.AbstractRichPlugin;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.plugin.SingletonPlugin;

public class SingletonServiceTest {
    private PluginService pluginService;
    private ConvertService convertService;

    @Before
    public void setUp() {
        Context context = new Context(new Class[]{PluginService.class, ConvertService.class});
        this.pluginService = (PluginService)context.service(PluginService.class);
        this.convertService = (ConvertService)context.service(ConvertService.class);
    }

    @After
    public void tearDown() {
        this.pluginService.context().dispose();
    }

    @Test
    public void testSingletonServicePluginsAddedHandling() {
        PluginInfo converterInfo = new PluginInfo(FoodConverter.class, Converter.class);
        this.pluginService.addPlugin(converterInfo);
        Assert.assertNotNull((Object)this.pluginService.getPlugin(FoodConverter.class));
        Assert.assertTrue((boolean)this.convertService.supports((Object)new Apple(){}, Peach.class));
    }

    @Test
    public void testSingletonServicePluginsAddedHandlingDuplicates() {
        PluginInfo converterInfo = new PluginInfo(FoodConverter.class, Converter.class);
        this.pluginService.addPlugin(converterInfo);
        FoodConverter firstInstance = (FoodConverter)this.convertService.getInstance(FoodConverter.class);
        this.pluginService.addPlugin(converterInfo);
        FoodConverter secondInstance = (FoodConverter)this.convertService.getInstance(FoodConverter.class);
        Assert.assertNotSame((Object)((Object)firstInstance), (Object)((Object)secondInstance));
        Assert.assertTrue((boolean)this.convertService.supports((Object)new Apple(){}, Peach.class));
    }

    @Test
    public void testSingletonServiceManuallyAddedPluginsRemovedHandling() {
        PluginInfo converterInfo = new PluginInfo(FoodConverter.class, Converter.class);
        this.pluginService.addPlugin(converterInfo);
        this.pluginService.removePlugin(converterInfo);
        Assert.assertNull((Object)this.pluginService.getPlugin(FoodConverter.class));
        Assert.assertFalse((boolean)this.convertService.supports((Object)new Apple(){}, Peach.class));
    }

    @Test
    public void testSingletonServiceCompileTimePluginsRemovedHandling() {
        PluginInfo pluginInfo = this.pluginService.getPlugin(DiscoveredFoodConverter.class);
        this.pluginService.removePlugin(pluginInfo);
        Assert.assertNull((Object)this.pluginService.getPlugin(DiscoveredFoodConverter.class));
        Assert.assertFalse((boolean)this.convertService.supports((Object)new Orange(){}, Peach.class));
    }

    @Test
    public void testListenToRemove() {
        Context ctx = new Context(new Class[]{PluginService.class, DummySingletonService.class, DummySingletonService2.class});
        DummySingletonService dss = (DummySingletonService)ctx.getService(DummySingletonService.class);
        DummySingletonService2 dss2 = (DummySingletonService2)ctx.getService(DummySingletonService2.class);
        List instances = dss.getInstances();
        DummyPlugin dummy = (DummyPlugin)((Object)instances.get(0));
        Assert.assertFalse((String)"Service not correctly initialized", (boolean)dss2.getInstances().isEmpty());
        PluginService ps = (PluginService)ctx.getService(PluginService.class);
        ps.removePlugin(dummy.getInfo());
        Assert.assertFalse((String)"Plugin was removed from wrong service!", (boolean)dss2.getInstances().isEmpty());
        Assert.assertTrue((String)"Plugin was not removed!", (boolean)dss.getInstances().isEmpty());
        ps.addPlugin(dummy.getInfo());
        Assert.assertEquals((String)"Wrong number of plugins in service:", (long)1L, (long)dss.getInstances().size());
        Assert.assertEquals((String)"Wrong number of plugins in independent service:", (long)1L, (long)dss2.getInstances().size());
    }

    public static class DummySingletonService2
    extends AbstractSingletonService<DummyPlugin2> {
        public Class<DummyPlugin2> getPluginType() {
            return DummyPlugin2.class;
        }
    }

    @Plugin(type=DummyPlugin2.class)
    public static class DummyPlugin2
    extends AbstractRichPlugin
    implements SingletonPlugin {
    }

    public static class DummySingletonService
    extends AbstractSingletonService<DummyPlugin> {
        public Class<DummyPlugin> getPluginType() {
            return DummyPlugin.class;
        }
    }

    @Plugin(type=DummyPlugin.class)
    public static class DummyPlugin
    extends AbstractRichPlugin
    implements SingletonPlugin {
    }

    public static interface Peach {
    }

    public static interface Orange {
    }

    public static interface Apple {
    }

    @Plugin(type=Converter.class)
    public static class DiscoveredFoodConverter
    extends AbstractConverter<Orange, Peach> {
        public <T> T convert(Object src, Class<T> dest) {
            return null;
        }

        public Class<Peach> getOutputType() {
            return Peach.class;
        }

        public Class<Orange> getInputType() {
            return Orange.class;
        }
    }

    public static class FoodConverter
    extends AbstractConverter<Apple, Peach> {
        public <T> T convert(Object src, Class<T> dest) {
            return null;
        }

        public Class<Peach> getOutputType() {
            return Peach.class;
        }

        public Class<Apple> getInputType() {
            return Apple.class;
        }
    }
}

