/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.Optional;
import org.scijava.app.DefaultAppService;
import org.scijava.app.DefaultStatusService;
import org.scijava.cache.DefaultCacheService;
import org.scijava.command.DefaultCommandService;
import org.scijava.console.DefaultConsoleService;
import org.scijava.convert.DefaultConvertService;
import org.scijava.display.DefaultDisplayService;
import org.scijava.download.DefaultDownloadService;
import org.scijava.event.DefaultEventHistory;
import org.scijava.event.DefaultEventService;
import org.scijava.input.DefaultInputService;
import org.scijava.io.DefaultIOService;
import org.scijava.io.DefaultRecentFileService;
import org.scijava.io.handle.DefaultDataHandleService;
import org.scijava.io.location.DefaultLocationService;
import org.scijava.io.nio.DefaultNIOService;
import org.scijava.log.StderrLogService;
import org.scijava.main.DefaultMainService;
import org.scijava.menu.DefaultMenuService;
import org.scijava.module.DefaultModuleService;
import org.scijava.object.DefaultObjectService;
import org.scijava.options.DefaultOptionsService;
import org.scijava.parse.DefaultParseService;
import org.scijava.platform.DefaultAppEventService;
import org.scijava.platform.DefaultPlatformService;
import org.scijava.plugin.DefaultPluginService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginIndex;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SciJavaPlugin;
import org.scijava.prefs.DefaultPrefService;
import org.scijava.run.DefaultRunService;
import org.scijava.script.DefaultScriptHeaderService;
import org.scijava.script.DefaultScriptService;
import org.scijava.script.process.DefaultScriptProcessorService;
import org.scijava.service.AbstractService;
import org.scijava.service.SciJavaService;
import org.scijava.service.Service;
import org.scijava.startup.DefaultStartupService;
import org.scijava.task.DefaultTaskService;
import org.scijava.text.DefaultTextService;
import org.scijava.text.io.DefaultTextIOService;
import org.scijava.thread.DefaultThreadService;
import org.scijava.thread.ThreadService;
import org.scijava.tool.DefaultToolService;
import org.scijava.ui.DefaultUIService;
import org.scijava.ui.dnd.DefaultDragAndDropService;
import org.scijava.util.ArrayUtils;
import org.scijava.welcome.DefaultWelcomeService;
import org.scijava.widget.DefaultWidgetService;

public class ContextCreationTest {
    @Test
    public void testEmpty() {
        Context context = new Context(true);
        Assert.assertTrue((boolean)context.getServiceIndex().isEmpty());
        Assert.assertFalse((boolean)context.getPluginIndex().isEmpty());
    }

    @Test
    public void testNoPlugins() {
        Context context = new Context(true, true);
        Assert.assertTrue((boolean)context.getServiceIndex().isEmpty());
        Assert.assertTrue((boolean)context.getPluginIndex().isEmpty());
    }

    @Test
    public void testFull() {
        Class[] expected = new Class[]{DefaultEventService.class, DefaultAppService.class, DefaultStatusService.class, DefaultCommandService.class, DefaultConsoleService.class, DefaultConvertService.class, DefaultDisplayService.class, DefaultDownloadService.class, DefaultEventHistory.class, DefaultInputService.class, DefaultIOService.class, DefaultRecentFileService.class, DefaultDataHandleService.class, DefaultLocationService.class, DefaultNIOService.class, DefaultMainService.class, DefaultMenuService.class, DefaultModuleService.class, DefaultObjectService.class, DefaultOptionsService.class, DefaultParseService.class, DefaultPlatformService.class, DefaultPluginService.class, DefaultPrefService.class, DefaultRunService.class, DefaultScriptHeaderService.class, DefaultScriptService.class, DefaultScriptProcessorService.class, DefaultStartupService.class, DefaultTaskService.class, DefaultTextService.class, DefaultTextIOService.class, DefaultThreadService.class, DefaultToolService.class, DefaultUIService.class, DefaultDragAndDropService.class, DefaultWelcomeService.class, DefaultWidgetService.class, StderrLogService.class, DefaultAppEventService.class, DefaultCacheService.class};
        Context context = new Context();
        this.verifyServiceOrder(expected, context);
    }

    @Test
    public void testSciJavaServices() {
        Context full = new Context();
        Context sciJava = new Context(new Class[]{SciJavaService.class});
        for (Service s : full.getServiceIndex()) {
            Class<?> c = s.getClass();
            Service sjs = sciJava.getService(c);
            if (sjs != null) continue;
            Assert.fail((String)("Not a SciJavaService? " + s.getClass().getName()));
        }
    }

    @Test
    public void testDependencies() {
        Context context = new Context(new Class[]{FooService.class});
        FooService fooService = (FooService)context.getService(FooService.class);
        Assert.assertNotNull((Object)((Object)fooService));
        Assert.assertSame((Object)context, (Object)fooService.getContext());
        BarService barService = (BarService)context.getService(BarService.class);
        Assert.assertNotNull((Object)((Object)barService));
        Assert.assertSame((Object)context, (Object)barService.getContext());
        Assert.assertSame((Object)((Object)barService), (Object)((Object)fooService.barService));
        Assert.assertEquals((long)2L, (long)context.getServiceIndex().size());
    }

    @Test
    public void testMissingDirect() {
        try {
            new Context(new Class[]{MissingService.class});
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException exc) {
            String expectedMessage = "No compatible service: " + MissingService.class.getName();
            Assert.assertEquals((Object)expectedMessage, (Object)exc.getMessage());
        }
    }

    @Test
    public void testMissingTransitive() {
        try {
            new Context(new Class[]{ServiceRequiringMissingService.class});
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException exc) {
            String expectedMessage = "Invalid service: " + ServiceRequiringMissingService.class.getName();
            Assert.assertEquals((Object)expectedMessage, (Object)exc.getMessage());
            String expectedCause = "No compatible service: " + MissingService.class.getName();
            Assert.assertEquals((Object)expectedCause, (Object)exc.getCause().getMessage());
        }
    }

    @Test
    public void testOptionalMissingTransitive() {
        try {
            new Context(new Class[]{ServiceRequiringOptionalMissingService.class});
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException exc) {
            String expectedMessage = "Invalid service: " + ServiceRequiringOptionalMissingService.class.getName();
            Assert.assertEquals((Object)expectedMessage, (Object)exc.getMessage());
            String expectedCause = "No compatible service: " + OptionalMissingService.class.getName();
            Assert.assertEquals((Object)expectedCause, (Object)exc.getCause().getMessage());
        }
    }

    @Test
    public void testNonStrictMissingDirect() {
        List serviceClasses = Context.serviceClassList((Class[])new Class[]{MissingService.class});
        Context context = new Context((Collection)serviceClasses, false);
        Assert.assertEquals((long)0L, (long)context.getServiceIndex().size());
    }

    @Test
    public void testNonStrictMissingTransitive() {
        List serviceClasses = Context.serviceClassList((Class[])new Class[]{MissingService.class});
        Context context = new Context((Collection)serviceClasses, false);
        Assert.assertEquals((long)0L, (long)context.getServiceIndex().size());
    }

    @Test
    public void testNonStrictOptionalMissingTransitive() {
        List serviceClasses = Context.serviceClassList((Class[])new Class[]{ServiceRequiringOptionalMissingService.class});
        Context context = new Context((Collection)serviceClasses, false);
        List services = context.getServiceIndex().getAll();
        Assert.assertEquals((long)1L, (long)services.size());
        Assert.assertSame(ServiceRequiringOptionalMissingService.class, ((Service)services.get(0)).getClass());
    }

    @Test
    public void testClassOrder() {
        int expectedSize = 2;
        Context c = this.createContext(this.pluginIndex(BaseImpl.class, ExtensionImpl.class), (Class[])ArrayUtils.array((Object[])new Class[]{BaseService.class, ExtensionService.class}));
        Assert.assertEquals((long)2L, (long)c.getServiceIndex().size());
        c = this.createContext(this.pluginIndex(ExtensionImpl.class, BaseImpl.class), (Class[])ArrayUtils.array((Object[])new Class[]{ExtensionService.class, BaseService.class}));
        Assert.assertEquals((long)2L, (long)c.getServiceIndex().size());
        c = this.createContext(this.pluginIndex(ExtensionImpl.class, BaseImpl.class), (Class[])ArrayUtils.array((Object[])new Class[]{BaseService.class, ExtensionService.class}));
        Assert.assertEquals((long)2L, (long)c.getServiceIndex().size());
        c = this.createContext(this.pluginIndex(BaseImpl.class, ExtensionImpl.class), (Class[])ArrayUtils.array((Object[])new Class[]{ExtensionService.class, BaseService.class}));
        Assert.assertEquals((long)2L, (long)c.getServiceIndex().size());
    }

    @Test
    public void testAbstractClasslist() {
        Context cAbstract = this.createContext(this.pluginIndex(BaseImpl.class, ExtensionImpl.class), (Class[])ArrayUtils.array((Object[])new Class[]{AbstractBase.class, AbstractExtension.class}));
        Context cService = this.createContext(this.pluginIndex(BaseImpl.class, ExtensionImpl.class), (Class[])ArrayUtils.array((Object[])new Class[]{BaseService.class, ExtensionService.class}));
        Assert.assertEquals((long)cService.getServiceIndex().size(), (long)cAbstract.getServiceIndex().size());
    }

    @Test
    public void testNoServicesCtor() {
        PluginIndex index = this.pluginIndex(BaseImpl.class, ExtensionImpl.class);
        index.add((Object)new PluginInfo(ThreadService.class.getName(), SciJavaPlugin.class));
        Context c = new Context(this.pluginIndex(BaseImpl.class, ExtensionImpl.class));
        Assert.assertEquals((long)2L, (long)c.getServiceIndex().size());
    }

    @Test
    public void testOptionalMissingDirect() {
        Context context = new Context(new Class[]{OptionalMissingService.class});
        OptionalMissingService optionalMissingService = (OptionalMissingService)context.getService(OptionalMissingService.class);
        Assert.assertNull((Object)optionalMissingService);
        Assert.assertEquals((long)0L, (long)context.getServiceIndex().size());
    }

    @Test
    public void testNonRequiredMissingService() {
        Context context = new Context(new Class[]{ServiceWantingMissingService.class});
        Assert.assertEquals((long)1L, (long)context.getServiceIndex().size());
        ServiceWantingMissingService serviceWantingMissingService = (ServiceWantingMissingService)context.getService(ServiceWantingMissingService.class);
        Assert.assertNotNull((Object)((Object)serviceWantingMissingService));
        Assert.assertNull((Object)serviceWantingMissingService.missingService);
        MissingService missingService = (MissingService)context.getService(MissingService.class);
        Assert.assertNull((Object)missingService);
        Assert.assertEquals((long)1L, (long)context.getServiceIndex().size());
    }

    private void verifyServiceOrder(Class<?>[] expected, Context context) {
        Assert.assertEquals((long)expected.length, (long)context.getServiceIndex().size());
        int index = 0;
        for (Service service : context.getServiceIndex()) {
            Assert.assertSame(expected[index++], service.getClass());
        }
    }

    private Context createContext(PluginIndex index, Class<? extends Service>[] services) {
        return new Context(Arrays.asList(services), index);
    }

    private PluginIndex pluginIndex(Class<?> ... plugins) {
        PluginIndex index = new PluginIndex(null);
        for (Class<?> c : plugins) {
            index.add((Object)new PluginInfo(c.getName(), Service.class));
        }
        return index;
    }

    public static class ServiceWantingMissingService
    extends AbstractService {
        @Parameter(required=false)
        private MissingService missingService;
    }

    public static class ServiceRequiringOptionalMissingService
    extends AbstractService {
        @Parameter
        private OptionalMissingService optionalMissingService;
    }

    public static class ServiceRequiringMissingService
    extends AbstractService {
        @Parameter
        private MissingService missingService;
    }

    public static class ExtensionImpl
    extends AbstractExtension {
    }

    public static class BaseImpl
    extends AbstractBase {
    }

    public static abstract class AbstractExtension
    extends AbstractService
    implements ExtensionService {
    }

    public static abstract class AbstractBase
    extends AbstractService
    implements BaseService {
    }

    public static interface OptionalMissingService
    extends Service,
    Optional {
    }

    public static interface MissingService
    extends Service {
    }

    public static class BarService
    extends AbstractService {
    }

    public static interface ExtensionService
    extends BaseService {
    }

    public static interface BaseService
    extends Service {
    }

    public static class FooService
    extends AbstractService {
        @Parameter
        private BarService barService;
    }
}

