/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import java.util.Iterator;
import org.scijava.util.AbstractPrimitiveArray;

public class ByteArray
extends AbstractPrimitiveArray<byte[], Byte> {
    private byte[] array;

    public ByteArray() {
        super(Byte.TYPE);
    }

    public ByteArray(int size) {
        super(Byte.TYPE, size);
    }

    public ByteArray(byte[] array) {
        super(Byte.TYPE, array);
    }

    public void addValue(byte value) {
        this.addValue(this.size(), value);
    }

    public boolean removeValue(byte value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.delete(index, 1);
        return true;
    }

    public byte getValue(int index) {
        this.checkBounds(index);
        return this.array[index];
    }

    public byte setValue(int index, byte value) {
        this.checkBounds(index);
        byte oldValue = this.getValue(index);
        this.array[index] = value;
        return oldValue;
    }

    public void addValue(int index, byte value) {
        this.insert(index, 1);
        this.array[index] = value;
    }

    public int indexOf(byte value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(byte value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public byte[] getArray() {
        return this.array;
    }

    @Override
    public void setArray(byte[] array) {
        if (array.length < this.size()) {
            throw new IllegalArgumentException("Array too small");
        }
        this.array = array;
    }

    @Override
    public Byte get(int index) {
        return this.getValue(index);
    }

    @Override
    public Byte set(int index, Byte element) {
        return this.setValue(index, element == null ? this.defaultValue() : element);
    }

    @Override
    public void add(int index, Byte element) {
        this.addValue(index, element);
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Byte)) {
            return -1;
        }
        byte value = (Byte)o;
        return this.indexOf(value);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Byte)) {
            return -1;
        }
        byte value = (Byte)o;
        return this.lastIndexOf(value);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Byte)) {
            return false;
        }
        byte value = (Byte)o;
        return this.contains(value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Byte)) {
            return false;
        }
        byte value = (Byte)o;
        return this.removeValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof Byte)) {
                return false;
            }
            byte value = (Byte)o;
            if (this.indexOf(value) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Byte> c) {
        if (c.size() == 0) {
            return false;
        }
        this.insert(index, c.size());
        int i = index;
        Iterator<? extends Byte> iterator = c.iterator();
        while (iterator.hasNext()) {
            byte e = iterator.next();
            this.setValue(i++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            byte value;
            boolean result;
            if (!(o instanceof Byte) || !(result = this.removeValue(value = ((Byte)o).byteValue()))) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public Byte defaultValue() {
        return (byte)0;
    }
}

