/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.AbstractDelegateConverter;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;

public class DelegateConverterTest {
    private Context context;

    @Before
    public void setUp() {
        this.context = new Context();
    }

    @After
    public void tearDown() {
        this.context.dispose();
        this.context = null;
    }

    @Test
    public void testDelegateConverters() {
        ConvertService convertService = (ConvertService)this.context.getService(ConvertService.class);
        AType a = new AType();
        Assert.assertTrue((boolean)convertService.supports((Object)a, BType.class));
        BType b = (BType)convertService.convert((Object)a, BType.class);
        Assert.assertSame(BType.class, b.getClass());
        Assert.assertTrue((boolean)convertService.supports((Object)b, CType.class));
        CType c = (CType)convertService.convert((Object)b, CType.class);
        Assert.assertSame(CType.class, c.getClass());
        Assert.assertTrue((boolean)convertService.supports((Object)a, CType.class));
        CType converted = (CType)convertService.convert((Object)a, CType.class);
        Assert.assertSame(c.getClass(), converted.getClass());
    }

    @Plugin(type=Converter.class)
    public static class DelegateConverter
    extends AbstractDelegateConverter<AType, BType, CType> {
        public Class<CType> getOutputType() {
            return CType.class;
        }

        public Class<AType> getInputType() {
            return AType.class;
        }

        protected Class<BType> getDelegateType() {
            return BType.class;
        }
    }

    @Plugin(type=Converter.class)
    public static class BCConverter
    extends AbstractConverter<BType, CType> {
        public <T> T convert(Object src, Class<T> dest) {
            return (T)new CType();
        }

        public Class<CType> getOutputType() {
            return CType.class;
        }

        public Class<BType> getInputType() {
            return BType.class;
        }
    }

    @Plugin(type=Converter.class)
    public static class ABConverter
    extends AbstractConverter<AType, BType> {
        public <T> T convert(Object src, Class<T> dest) {
            return (T)new BType();
        }

        public Class<BType> getOutputType() {
            return BType.class;
        }

        public Class<AType> getInputType() {
            return AType.class;
        }
    }

    public static class CType {
    }

    public static class BType {
    }

    public static class AType {
    }
}

