/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.parse.Item;
import org.scijava.parse.Items;
import org.scijava.parse.ParseService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Types;

@Plugin(type=Converter.class, priority=-10000.0)
public class StringToArrayConverter
extends AbstractConverter<String, Object> {
    @Parameter(required=false)
    private ConvertService convertService;
    @Parameter(required=false)
    private ParseService parseService;

    @Override
    public boolean canConvert(Class<?> src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        Class<?> saneSrc = Types.box(src);
        Class<?> saneDest = Types.box(dest);
        return saneSrc == String.class && saneDest.isArray();
    }

    @Override
    public boolean canConvert(Object src, Type dest) {
        return this.canConvert(src, Types.raw(dest));
    }

    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        Items tree;
        if (this.convertService == null || this.parseService == null) {
            return false;
        }
        if (!this.canConvert(src.getClass(), dest)) {
            return false;
        }
        try {
            tree = this.parseService.parse((String)src);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (tree.size() == 0) {
            return true;
        }
        Object testSrc = ((Item)tree.get(0)).value();
        Class<?> testDest = this.unitComponentType(dest);
        return this.convertService.supports(testSrc, testDest);
    }

    @Override
    public Object convert(Object src, Type dest) {
        Type componentType = Types.component(dest);
        if (componentType == null) {
            throw new IllegalArgumentException(dest + " is not an array type!");
        }
        try {
            return this.convertToArray(this.parseService.parse((String)src), Types.raw(componentType));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        return (T)this.convert(src, (Type)dest);
    }

    @Override
    public Class<Object> getOutputType() {
        return Object.class;
    }

    @Override
    public Class<String> getInputType() {
        return String.class;
    }

    private Object convertToArray(Items tree, Class<?> componentType) {
        Object array = Array.newInstance(componentType, tree.size());
        for (int i = 0; i < tree.size(); ++i) {
            Object element = this.convertService.convert(((Item)tree.get(i)).value(), componentType);
            Array.set(array, i, element);
        }
        return array;
    }

    private Class<?> unitComponentType(Class<?> c) {
        if (!c.isArray()) {
            return c;
        }
        return c.getComponentType();
    }
}

