/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.util.List;
import java.util.concurrent.Callable;
import org.scijava.AbstractContextual;
import org.scijava.Cancelable;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.event.ModuleCanceledEvent;
import org.scijava.module.event.ModuleErroredEvent;
import org.scijava.module.event.ModuleExecutedEvent;
import org.scijava.module.event.ModuleExecutingEvent;
import org.scijava.module.event.ModuleFinishedEvent;
import org.scijava.module.event.ModulePostprocessEvent;
import org.scijava.module.event.ModulePreprocessEvent;
import org.scijava.module.event.ModuleStartedEvent;
import org.scijava.module.process.ModulePostprocessor;
import org.scijava.module.process.ModulePreprocessor;
import org.scijava.plugin.Parameter;

public class ModuleRunner
extends AbstractContextual
implements Callable<Module>,
Runnable {
    private final Module module;
    private final List<? extends ModulePreprocessor> pre;
    private final List<? extends ModulePostprocessor> post;
    @Parameter(required=false)
    private EventService es;
    @Parameter(required=false)
    private StatusService ss;
    @Parameter(required=false)
    private LogService log;

    public ModuleRunner(Context context, Module module, List<? extends ModulePreprocessor> pre, List<? extends ModulePostprocessor> post) {
        this.setContext(context);
        this.module = module;
        this.pre = pre;
        this.post = post;
    }

    public ModulePreprocessor preProcess() {
        if (this.pre == null) {
            return null;
        }
        for (ModulePreprocessor modulePreprocessor : this.pre) {
            modulePreprocessor.process(this.module);
            if (this.es != null) {
                this.es.publish(new ModulePreprocessEvent(this.module, modulePreprocessor));
            }
            if (!modulePreprocessor.isCanceled()) continue;
            return modulePreprocessor;
        }
        return null;
    }

    public void postProcess() {
        if (this.post == null) {
            return;
        }
        for (ModulePostprocessor modulePostprocessor : this.post) {
            modulePostprocessor.process(this.module);
            if (this.es == null) continue;
            this.es.publish(new ModulePostprocessEvent(this.module, modulePostprocessor));
        }
    }

    @Override
    public Module call() {
        try {
            this.run();
        }
        catch (RuntimeException exc) {
            throw new RuntimeException("Module threw exception", exc);
        }
        catch (Error err) {
            throw new RuntimeException("Module threw error", err);
        }
        return this.module;
    }

    @Override
    public void run() {
        if (this.module == null) {
            return;
        }
        String title = this.module.getInfo().getTitle();
        try {
            ModulePreprocessor canceler;
            if (this.ss != null) {
                this.ss.showStatus("Running command: " + title);
            }
            if (this.es != null) {
                this.es.publish(new ModuleStartedEvent(this.module));
            }
            if ((canceler = this.preProcess()) != null) {
                String reason = canceler.getCancelReason();
                this.cancel(reason);
                this.cleanupAndBroadcastCancelation(title, reason);
                return;
            }
            if (this.es != null) {
                this.es.publish(new ModuleExecutingEvent(this.module));
            }
            this.module.run();
            if (this.isCanceled()) {
                this.cleanupAndBroadcastCancelation(title, this.getCancelReason());
                return;
            }
            if (this.es != null) {
                this.es.publish(new ModuleExecutedEvent(this.module));
            }
            this.postProcess();
            if (this.es != null) {
                this.es.publish(new ModuleFinishedEvent(this.module));
            }
            if (this.ss != null) {
                this.ss.showStatus("Command finished: " + title);
            }
        }
        catch (Throwable t) {
            this.cleanupAndBroadcastException(title, t);
            throw t;
        }
    }

    private void cleanupAndBroadcastCancelation(String title, String reason) {
        if (this.ss != null) {
            this.ss.showStatus("Canceling command: " + title);
        }
        this.module.cancel();
        if (this.es != null) {
            this.es.publish(new ModuleCanceledEvent(this.module, reason));
        }
        if (this.ss != null) {
            this.ss.showStatus("Command canceled: " + title);
            if (reason != null) {
                this.ss.warn(reason);
            }
        }
    }

    private void cleanupAndBroadcastException(String title, Throwable t) {
        ModuleErroredEvent evt = new ModuleErroredEvent(this.module, t);
        if (this.es != null) {
            this.es.publish(evt);
        }
        if (this.log != null && !evt.isConsumed()) {
            this.log.error("Command errored: " + title, t);
        }
    }

    private boolean isCanceled() {
        return this.module instanceof Cancelable && ((Cancelable)((Object)this.module)).isCanceled();
    }

    private String getCancelReason() {
        return this.module instanceof Cancelable ? ((Cancelable)((Object)this.module)).getCancelReason() : null;
    }

    private void cancel(String reason) {
        if (!(this.module instanceof Cancelable)) {
            return;
        }
        ((Cancelable)((Object)this.module)).cancel(reason);
    }
}

