/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.event;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.module.AbstractModule;
import org.scijava.module.AbstractModuleInfo;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.module.event.ModuleErroredEvent;

public class ModuleErroredEventTest {
    private EventService es;
    private ModuleService module;

    @Before
    public void setUp() {
        Context ctx = new Context();
        this.es = (EventService)ctx.getService(EventService.class);
        this.module = (ModuleService)ctx.getService(ModuleService.class);
    }

    @Test
    public void testModuleErroredEvent() {
        final Throwable[] caughtException = new Throwable[]{null};
        Object interestedParty = new Object(){

            @EventHandler
            void onEvent(ModuleErroredEvent e) {
                caughtException[0] = e.getException();
            }
        };
        this.es.subscribe(interestedParty);
        Assert.assertThrows(Exception.class, () -> {
            Module cfr_ignored_0 = (Module)this.module.run((ModuleInfo)new TestModuleInfo(), false, new Object[0]).get();
        });
        Assert.assertNotNull((Object)caughtException[0]);
        Assert.assertEquals((Object)"Yay!", (Object)caughtException[0].getMessage());
    }

    static class TestModuleInfo
    extends AbstractModuleInfo {
        TestModuleInfo() {
        }

        public String getDelegateClassName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public Class<?> loadDelegateClass() throws ClassNotFoundException {
            return ((Object)((Object)this)).getClass();
        }

        public Module createModule() throws ModuleException {
            TestModuleInfo thisInfo = this;
            return new AbstractModule((ModuleInfo)thisInfo){
                final /* synthetic */ ModuleInfo val$thisInfo;
                {
                    this.val$thisInfo = moduleInfo;
                }

                public ModuleInfo getInfo() {
                    return this.val$thisInfo;
                }

                public void run() {
                    throw new RuntimeException("Yay!");
                }
            };
        }
    }
}

