/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.download;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.download.DiskLocationCache;
import org.scijava.download.Download;
import org.scijava.download.DownloadService;
import org.scijava.download.LocationCache;
import org.scijava.io.ByteBank;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.test.TestUtils;
import org.scijava.util.FileUtils;
import org.scijava.util.MersenneTwisterFast;

public class DownloadServiceTest {
    private DownloadService downloadService;

    @Before
    public void setUp() {
        Context ctx = new Context(new Class[]{DownloadService.class});
        this.downloadService = (DownloadService)ctx.service(DownloadService.class);
    }

    @After
    public void tearDown() {
        this.downloadService.context().dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDownload() throws IOException, InterruptedException, ExecutionException {
        byte[] data = this.randomBytes(-1161905474L);
        String prefix = this.getClass().getName();
        File inFile = File.createTempFile(prefix, "testDownloadIn");
        File outFile = File.createTempFile(prefix, "testDownloadOut");
        try {
            FileUtils.writeFile((File)inFile, (byte[])data);
            FileLocation src = new FileLocation(inFile);
            FileLocation dest = new FileLocation(outFile);
            Download download = this.downloadService.download((Location)src, (Location)dest);
            download.task().waitFor();
            byte[] result = FileUtils.readFile((File)outFile);
            Assert.assertArrayEquals((byte[])data, (byte[])result);
        }
        finally {
            inFile.delete();
            outFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDownloadCache() throws IOException, InterruptedException, ExecutionException {
        byte[] data = this.randomBytes(-889271554L);
        String prefix = this.getClass().getName();
        File inFile = File.createTempFile(prefix, "testDownloadCacheIn");
        FileLocation src = new FileLocation(inFile);
        BytesLocation dest = new BytesLocation(data.length);
        File cacheDir = TestUtils.createTemporaryDirectory((String)"testDownloadCacheBase", this.getClass());
        DiskLocationCache cache = new DiskLocationCache();
        cache.setBaseDirectory(cacheDir);
        cache.setFileLocationCachingEnabled(true);
        try {
            FileUtils.writeFile((File)inFile, (byte[])data);
            Assert.assertNull((Object)cache.loadChecksum((Location)src));
            Location cachedSource = cache.cachedLocation((Location)src);
            Assert.assertTrue((boolean)(cachedSource instanceof FileLocation));
            FileLocation cachedFile = (FileLocation)cachedSource;
            Assert.assertFalse((boolean)cachedFile.getFile().exists());
            Download download = this.downloadService.download((Location)src, (Location)dest, (LocationCache)cache);
            download.task().waitFor();
            this.assertBytesEqual(data, dest.getByteBank());
            Assert.assertEquals((Object)cachedSource, (Object)cache.cachedLocation((Location)src));
            Assert.assertTrue((boolean)cachedFile.getFile().exists());
            byte[] cachedData = FileUtils.readFile((File)cachedFile.getFile());
            Assert.assertArrayEquals((byte[])data, (byte[])cachedData);
            inFile.delete();
            Assert.assertFalse((boolean)inFile.exists());
            BytesLocation dest2 = new BytesLocation(data.length);
            Download download2 = this.downloadService.download((Location)src, (Location)dest2, (LocationCache)cache);
            download2.task().waitFor();
            this.assertBytesEqual(data, dest2.getByteBank());
        }
        finally {
            if (inFile.exists()) {
                inFile.delete();
            }
            FileUtils.deleteRecursively((File)cacheDir);
        }
    }

    private byte[] randomBytes(long seed) {
        MersenneTwisterFast r = new MersenneTwisterFast(seed);
        byte[] data = new byte[2938740];
        for (int i = 0; i < data.length; ++i) {
            data[i] = r.nextByte();
        }
        return data;
    }

    private void assertBytesEqual(byte[] data, ByteBank byteBank) {
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((long)data[i], (long)byteBank.getByte((long)i));
        }
    }
}

