/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.scijava.util.Sizable;

public class SizableArrayList<E>
extends ArrayList<E>
implements Sizable {
    private static final long serialVersionUID = 1L;

    public SizableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SizableArrayList() {
    }

    public SizableArrayList(Collection<? extends E> c) {
        super(c);
    }

    @Override
    public void ensureCapacity(int capacity) {
        super.ensureCapacity(capacity < 11 ? 11 : capacity);
    }

    @Override
    public void setSize(int size) {
        int oldSize = this.size();
        if (oldSize == size) {
            return;
        }
        if (size < oldSize) {
            this.removeRange(size, oldSize);
        } else {
            this.ensureCapacity(size);
            boolean hackSuccessful = this.hackSize(size);
            if (!hackSuccessful) {
                while (this.size() < size) {
                    this.add(null);
                }
            }
        }
    }

    private boolean hackSize(int size) {
        try {
            Field sizeField = ArrayList.class.getDeclaredField("size");
            sizeField.setAccessible(true);
            int oldSize = (Integer)sizeField.get(this);
            sizeField.set(this, size);
            try {
                this.get(size - 1);
            }
            catch (Exception exc) {
                sizeField.set(this, oldSize);
                return false;
            }
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }
}

