/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scijava.io.handle.AbstractDataHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.ReadBufferDataHandle;
import org.scijava.io.location.DummyLocation;
import org.scijava.io.location.Location;

public class ReadBufferDataHandleMockTest {
    private DataHandle<Location> mock;
    private AbstractDataHandle<Location> buf;
    private byte[] byteArrayLen10;
    private long innerOffset;

    @Before
    public void setup() throws IOException {
        this.innerOffset = 0L;
        this.mock = (DataHandle)Mockito.mock(DataHandle.class);
        Mockito.when((Object)this.mock.get()).thenReturn((Object)new DummyLocation());
        Mockito.when((Object)this.mock.getType()).thenReturn(Location.class);
        this.buf = new ReadBufferDataHandle(this.mock, 10, 2);
        this.byteArrayLen10 = new byte[10];
        Mockito.when((Object)this.mock.read((byte[])ArgumentMatchers.any(byte[].class))).thenAnswer(inv -> {
            this.innerOffset += (long)((byte[])inv.getArgument(0)).length;
            return null;
        });
        ((DataHandle)Mockito.doAnswer(inv -> {
            this.innerOffset = (Long)inv.getArgument(0);
            return null;
        }).when(this.mock)).seek(ArgumentMatchers.anyLong());
        Mockito.when((Object)this.mock.offset()).then(inv -> this.innerOffset);
    }

    @Test
    public void testBufferingSequence() throws IOException {
        Mockito.when((Object)this.mock.length()).thenReturn((Object)30L);
        byte[] value = new byte[10];
        Mockito.when((Object)this.mock.read(AdditionalMatchers.aryEq((byte[])value), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)10))).thenReturn((Object)10);
        Mockito.when((Object)this.mock.read(AdditionalMatchers.aryEq((byte[])value), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)10);
        this.buf.read();
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)0))).seek(0L);
        ((DataHandle)Mockito.verify(this.mock)).read(AdditionalMatchers.aryEq((byte[])this.byteArrayLen10), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)10));
        this.buf.seek(0L);
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)0))).seek(0L);
        Mockito.when((Object)this.mock.offset()).thenReturn((Object)10L);
        this.buf.read(new byte[12]);
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)0))).seek(ArgumentMatchers.anyLong());
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)2))).read(AdditionalMatchers.aryEq((byte[])this.byteArrayLen10), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)10));
        Assert.assertEquals((long)12L, (long)this.buf.offset());
        Mockito.when((Object)this.mock.offset()).thenReturn((Object)20L);
        this.buf.read(new byte[12]);
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)0))).seek(ArgumentMatchers.anyLong());
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)3))).read(AdditionalMatchers.aryEq((byte[])this.byteArrayLen10), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)10));
        this.buf.seek(0L);
        this.buf.read();
        ((DataHandle)Mockito.verify(this.mock)).seek(0L);
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)4))).read(AdditionalMatchers.aryEq((byte[])this.byteArrayLen10), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)10));
    }

    @Test
    public void testSkipForward() throws IOException {
        Mockito.when((Object)this.mock.length()).thenReturn((Object)40L);
        Mockito.when((Object)this.mock.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)10);
        this.buf.read();
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)0))).seek(ArgumentMatchers.anyLong());
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)1))).read(AdditionalMatchers.aryEq((byte[])this.byteArrayLen10), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)10));
        this.buf.seek(30L);
        this.buf.read();
        ((DataHandle)Mockito.verify(this.mock)).seek(30L);
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)2))).read(AdditionalMatchers.aryEq((byte[])this.byteArrayLen10), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)10));
        Mockito.when((Object)this.mock.offset()).thenReturn((Object)40L);
        this.buf.seek(0L);
        this.buf.read();
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        this.buf.seek(35L);
        this.buf.read();
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        ((DataHandle)Mockito.verify(this.mock, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }
}

