/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.util.PropertiesHelper;

public class PropertiesHelperTest {
    private static final String EXPECTED_1 = "a=b";
    private static final String EXPECTED_2 = "hello=goodbye";
    private Map<String, String> props;
    private File temp;

    @Before
    public void setup() throws IOException {
        this.temp = File.createTempFile("PropertiesHelper", "txt");
        this.props = new HashMap<String, String>();
        this.props.put("a", "b");
        this.props.put("hello", "goodbye");
    }

    @After
    public void cleanup() {
        this.temp.delete();
    }

    @Test
    public void testWrite() throws IOException {
        PropertiesHelper.put(this.props, (File)this.temp);
        int count = 0;
        boolean saw1 = false;
        boolean saw2 = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.temp));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.equals(EXPECTED_1)) {
                    saw1 = true;
                }
                if (line.equals(EXPECTED_2)) {
                    saw2 = true;
                }
                ++count;
            }
        }
        Assert.assertTrue((boolean)saw1);
        Assert.assertTrue((boolean)saw2);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testRead() throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.temp));){
            writer.write(EXPECTED_1);
            writer.newLine();
            writer.write(EXPECTED_2);
            writer.newLine();
        }
        Map propsMap = PropertiesHelper.get((File)this.temp);
        Assert.assertTrue((boolean)this.props.equals(propsMap));
    }

    @Test
    public void testIO() throws IOException {
        PropertiesHelper.put(this.props, (File)this.temp);
        Map propsMap = PropertiesHelper.get((File)this.temp);
        Assert.assertTrue((boolean)this.props.equals(propsMap));
    }

    @Test
    public void testMultipleEquals() throws IOException {
        this.props.clear();
        String K = "hello";
        String V = "world=true";
        this.props.put("hello", "world=true");
        PropertiesHelper.put(this.props, (File)this.temp);
        Map propsMap = PropertiesHelper.get((File)this.temp);
        Assert.assertEquals((long)1L, (long)propsMap.size());
        Assert.assertEquals((Object)this.props.get("hello"), propsMap.get("hello"));
    }

    @Test
    public void testOverwrite() throws IOException {
        PropertiesHelper.put(this.props, (File)this.temp);
        this.props.put("myname", "jonas");
        PropertiesHelper.put(this.props, (File)this.temp);
        Map loadedProps = PropertiesHelper.get((File)this.temp);
        Assert.assertEquals((long)3L, (long)loadedProps.size());
        int count = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.temp));){
            String line;
            while ((line = reader.readLine()) != null) {
                ++count;
            }
        }
        Assert.assertEquals((long)3L, (long)count);
    }
}

