/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.sjep.AbstractTest;
import org.scijava.sjep.Literals;
import org.scijava.sjep.Position;

public class LiteralsTest
extends AbstractTest {
    @Test
    public void testParseBoolean() {
        Assert.assertSame((Object)Boolean.FALSE, (Object)Literals.parseBoolean((CharSequence)"false"));
        Assert.assertSame((Object)Boolean.TRUE, (Object)Literals.parseBoolean((CharSequence)"true"));
        Assert.assertNull((Object)Literals.parseBoolean((CharSequence)"zfalse"));
        Assert.assertNull((Object)Literals.parseBoolean((CharSequence)"zfalsez"));
        Assert.assertNull((Object)Literals.parseBoolean((CharSequence)"ztrue"));
        Assert.assertNull((Object)Literals.parseBoolean((CharSequence)"ztruez"));
        Position pos = new Position();
        pos.set(0);
        Assert.assertSame((Object)Boolean.FALSE, (Object)Literals.parseBoolean((CharSequence)"false-", (Position)pos));
        Assert.assertEquals((long)5L, (long)pos.get());
        pos.set(0);
        Assert.assertSame((Object)Boolean.TRUE, (Object)Literals.parseBoolean((CharSequence)"true-", (Position)pos));
        Assert.assertEquals((long)4L, (long)pos.get());
    }

    @Test
    public void testParseString() {
        Assert.assertEquals((Object)"hello world", (Object)Literals.parseString((CharSequence)"'hello world'"));
        Assert.assertEquals((Object)"a\b\t\n\f\r\"\\z", (Object)Literals.parseString((CharSequence)"\"a\\b\\t\\n\\f\\r\\\"\\\\z\""));
        Assert.assertEquals((Object)"\t\\\t\\\\\t", (Object)Literals.parseString((CharSequence)"\"\\t\\\\\\t\\\\\\\\\\t\""));
        Assert.assertEquals((Object)"\u0000", (Object)Literals.parseString((CharSequence)"\"\\0\""));
        Assert.assertEquals((Object)"\u0000", (Object)Literals.parseString((CharSequence)"\"\\00\""));
        Assert.assertEquals((Object)"\u0000", (Object)Literals.parseString((CharSequence)"\"\\000\""));
        Assert.assertEquals((Object)"\n", (Object)Literals.parseString((CharSequence)"\"\\12\""));
        Assert.assertEquals((Object)"S", (Object)Literals.parseString((CharSequence)"\"\\123\""));
        Assert.assertEquals((Object)"\u00ff", (Object)Literals.parseString((CharSequence)"\"\\377\""));
        Assert.assertEquals((Object)"S4", (Object)Literals.parseString((CharSequence)"\"\\1234\""));
        Position pos = new Position();
        pos.set(2);
        Assert.assertEquals((Object)"cde", (Object)Literals.parseString((CharSequence)"ab'cde'fg", (Position)pos));
        Assert.assertEquals((long)7L, (long)pos.get());
    }

    @Test
    public void testParseStringInvalid() {
        Assert.assertNull((Object)Literals.parseString((CharSequence)""));
        Assert.assertNull((Object)Literals.parseString((CharSequence)"1234"));
        Assert.assertNull((Object)Literals.parseString((CharSequence)"foo"));
        Assert.assertNull((Object)Literals.parseString((CharSequence)"a'b'c"));
        try {
            Literals.parseString((CharSequence)"'");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertEquals((Object)"Unclosed string literal at index 0", (Object)exc.getMessage());
        }
    }

    @Test
    public void testParseHex() {
        this.assertNumber(291, Literals.parseHex((CharSequence)"0x123"));
        this.assertNumber(291L, Literals.parseHex((CharSequence)"0x123L"));
        this.assertNumber(81985529216486895L, Literals.parseHex((CharSequence)"0x123456789abcdef"));
        String big = "123456789abcdeffedcba987654321";
        Number bigNum = Literals.parseHex((CharSequence)"0x123456789abcdeffedcba987654321");
        this.assertNumber(new BigInteger("123456789abcdeffedcba987654321", 16), bigNum);
    }

    @Test
    public void testParseHexNegative() {
        this.assertNumber(-291, Literals.parseHex((CharSequence)"-0x123"));
        this.assertNumber(-291L, Literals.parseHex((CharSequence)"-0x123L"));
        this.assertNumber(-81985529216486895L, Literals.parseHex((CharSequence)"-0x123456789abcdef"));
        String big = "123456789abcdeffedcba987654321";
        Number bigNum = Literals.parseHex((CharSequence)"-0x123456789abcdeffedcba987654321");
        this.assertNumber(new BigInteger("-123456789abcdeffedcba987654321", 16), bigNum);
    }

    @Test
    public void testParseBinary() {
        this.assertNumber(33, Literals.parseBinary((CharSequence)"0b100001"));
        this.assertNumber(33L, Literals.parseBinary((CharSequence)"0b100001L"));
        String big = "10110011100011110000111110000011111100000011111110000000111111110000000011111111100000000011111111110000000000";
        Number bigNum = Literals.parseBinary((CharSequence)"0b10110011100011110000111110000011111100000011111110000000111111110000000011111111100000000011111111110000000000");
        this.assertNumber(new BigInteger("10110011100011110000111110000011111100000011111110000000111111110000000011111111100000000011111111110000000000", 2), bigNum);
    }

    @Test
    public void testParseBinaryNegative() {
        this.assertNumber(-33, Literals.parseBinary((CharSequence)"-0b100001"));
        this.assertNumber(-33L, Literals.parseBinary((CharSequence)"-0b100001L"));
        String big = "10110011100011110000111110000011111100000011111110000000111111110000000011111111100000000011111111110000000000";
        Number bigNum = Literals.parseBinary((CharSequence)"-0b10110011100011110000111110000011111100000011111110000000111111110000000011111111100000000011111111110000000000");
        this.assertNumber(new BigInteger("-10110011100011110000111110000011111100000011111110000000111111110000000011111111100000000011111111110000000000", 2), bigNum);
    }

    @Test
    public void testParseOctal() {
        this.assertNumber(342391, Literals.parseOctal((CharSequence)"01234567"));
        this.assertNumber(342391L, Literals.parseOctal((CharSequence)"01234567L"));
        this.assertNumber(718048024785L, Literals.parseOctal((CharSequence)"012345677654321"));
        String big = "1234567765432112345677654321";
        Number bigNum = Literals.parseOctal((CharSequence)"01234567765432112345677654321");
        this.assertNumber(new BigInteger("1234567765432112345677654321", 8), bigNum);
    }

    @Test
    public void testParseOctalNegative() {
        this.assertNumber(-342391, Literals.parseOctal((CharSequence)"-01234567"));
        this.assertNumber(-342391L, Literals.parseOctal((CharSequence)"-01234567L"));
        this.assertNumber(-718048024785L, Literals.parseOctal((CharSequence)"-012345677654321"));
        String big = "1234567765432112345677654321";
        Number bigNum = Literals.parseOctal((CharSequence)"-01234567765432112345677654321");
        this.assertNumber(new BigInteger("-1234567765432112345677654321", 8), bigNum);
    }

    @Test
    public void testParseDecimal() {
        this.assertNumber(123456789, Literals.parseDecimal((CharSequence)"123456789"));
        this.assertNumber(123456789L, Literals.parseDecimal((CharSequence)"123456789L"));
        this.assertNumber(123456787654321L, Literals.parseDecimal((CharSequence)"123456787654321"));
        String bigI = "1234567898765432123456789";
        Number bigInt = Literals.parseDecimal((CharSequence)"1234567898765432123456789");
        this.assertNumber(new BigInteger("1234567898765432123456789"), bigInt);
        this.assertNumber(Float.valueOf(1.0f), Literals.parseDecimal((CharSequence)"1f"));
        this.assertNumber(1.0, Literals.parseDecimal((CharSequence)"1d"));
        this.assertNumber(1.0, Literals.parseDecimal((CharSequence)"1.0"));
        this.assertNumber(1.0, Literals.parseDecimal((CharSequence)"1."));
        this.assertNumber(100.0, Literals.parseDecimal((CharSequence)"1e2"));
        this.assertNumber(1200.0, Literals.parseDecimal((CharSequence)"1.2e3"));
        this.assertNumber(Float.valueOf(1200.0f), Literals.parseDecimal((CharSequence)"1.2e3f"));
    }

    @Test
    public void testParseDecimalNegative() {
        this.assertNumber(-123456789, Literals.parseDecimal((CharSequence)"-123456789"));
        this.assertNumber(-123456789L, Literals.parseDecimal((CharSequence)"-123456789L"));
        this.assertNumber(-123456787654321L, Literals.parseDecimal((CharSequence)"-123456787654321"));
        String bigI = "-1234567898765432123456789";
        Number bigInt = Literals.parseDecimal((CharSequence)"-1234567898765432123456789");
        this.assertNumber(new BigInteger("-1234567898765432123456789"), bigInt);
        this.assertNumber(Float.valueOf(-1.0f), Literals.parseDecimal((CharSequence)"-1f"));
        this.assertNumber(-1.0, Literals.parseDecimal((CharSequence)"-1d"));
        this.assertNumber(-1.0, Literals.parseDecimal((CharSequence)"-1.0"));
        this.assertNumber(-1.0, Literals.parseDecimal((CharSequence)"-1."));
        this.assertNumber(-100.0, Literals.parseDecimal((CharSequence)"-1e2"));
        this.assertNumber(-1200.0, Literals.parseDecimal((CharSequence)"-1.2e3"));
        this.assertNumber(Float.valueOf(-1200.0f), Literals.parseDecimal((CharSequence)"-1.2e3f"));
    }

    @Test
    public void testParseNumber() {
        Position pos = new Position();
        this.assertNumber(0, Literals.parseNumber((CharSequence)"0", (Position)pos));
        Assert.assertEquals((long)1L, (long)pos.get());
        pos.set(1);
        this.assertNumber(5.7, Literals.parseNumber((CharSequence)"a5.7a", (Position)pos));
        Assert.assertEquals((long)4L, (long)pos.get());
        pos.set(2);
        this.assertNumber(-11, Literals.parseNumber((CharSequence)"bb-11bb", (Position)pos));
        Assert.assertEquals((long)5L, (long)pos.get());
        pos.set(3);
        this.assertNumber(291L, Literals.parseNumber((CharSequence)"ccc0x123Lccc", (Position)pos));
        Assert.assertEquals((long)9L, (long)pos.get());
    }

    @Test
    public void testParseLiteral() {
        Assert.assertSame((Object)Boolean.FALSE, (Object)Literals.parseLiteral((CharSequence)"false"));
        Assert.assertSame((Object)Boolean.TRUE, (Object)Literals.parseLiteral((CharSequence)"true"));
        Assert.assertEquals((Object)"fubar", (Object)Literals.parseLiteral((CharSequence)"'fubar'"));
        this.assertNumber(0, Literals.parseLiteral((CharSequence)"0"));
    }
}

