/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import org.scijava.sjep.AbstractToken;
import org.scijava.sjep.Operator;

public class DefaultOperator
extends AbstractToken
implements Operator {
    private final int arity;
    private final Operator.Associativity associativity;
    private final double precedence;

    public DefaultOperator(String symbol, int arity, Operator.Associativity associativity, double precedence) {
        super(symbol);
        this.arity = arity;
        this.associativity = associativity;
        this.precedence = precedence;
    }

    @Override
    public Operator.Associativity getAssociativity() {
        return this.associativity;
    }

    @Override
    public boolean isLeftAssociative() {
        Operator.Associativity a = this.getAssociativity();
        return a == Operator.Associativity.LEFT || a == Operator.Associativity.EITHER;
    }

    @Override
    public boolean isRightAssociative() {
        Operator.Associativity a = this.getAssociativity();
        return a == Operator.Associativity.RIGHT || a == Operator.Associativity.EITHER;
    }

    @Override
    public boolean isInfix() {
        return this.getArity() > 1;
    }

    @Override
    public boolean isPrefix() {
        return this.getArity() == 1 && this.isRightAssociative();
    }

    @Override
    public boolean isPostfix() {
        return this.getArity() == 1 && this.isLeftAssociative();
    }

    @Override
    public double getPrecedence() {
        return this.precedence;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public int compareTo(Operator that) {
        double thatP;
        double thisP = this.getPrecedence();
        if (thisP == (thatP = that.getPrecedence())) {
            return 0;
        }
        return thisP < thatP ? -1 : 1;
    }
}

