/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CollectionOutput {
    public static <T> String joinCollection(Collection<T> collection, final StringProvider<T> stringProvider, String separator) {
        final StringBuilder output = new StringBuilder();
        CollectionOutput.joinCollection(collection, output, new Appender<T>(){

            @Override
            public void append(T value) {
                output.append(stringProvider.provide(value));
            }
        }, separator);
        return output.toString();
    }

    public static <T> String joinArray(T[] array, StringProvider<T> stringProvider, String separator) {
        List<T> list = Arrays.asList(array);
        return CollectionOutput.joinCollection(list, stringProvider, separator);
    }

    public static <T> void joinCollection(Collection<T> collection, StringBuilder output, Appender<T> appender, String separator) {
        boolean first = true;
        for (T element : collection) {
            if (!first) {
                output.append(separator);
            }
            appender.append(element);
            first = false;
        }
    }

    public static interface Appender<T> {
        public void append(T var1);
    }

    public static interface StringProvider<T> {
        public String provide(T var1);
    }
}

