/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.api;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpInstance;

public class InfoTree {
    public static final Character DEP_START_DELIM = Character.valueOf('{');
    public static final Character DEP_END_DELIM = Character.valueOf('}');
    public static final String DEPENDENCY_DELIM = "\n\tDepends upon: ";
    private final List<InfoTree> dependencies;
    private String id;
    private final OpInfo info;

    public InfoTree(OpInfo info) {
        this.info = info;
        this.dependencies = Collections.emptyList();
    }

    public InfoTree(OpInfo info, List<InfoTree> dependencies) {
        this.info = info;
        this.dependencies = new ArrayList<InfoTree>(dependencies);
    }

    public List<InfoTree> dependencies() {
        return this.dependencies;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InfoTree)) {
            return false;
        }
        return this.signature().equals(((InfoTree)obj).signature());
    }

    public int hashCode() {
        return this.signature().hashCode();
    }

    public String signature() {
        if (this.id == null) {
            this.generateSignature();
        }
        return this.id;
    }

    public OpInfo info() {
        return this.info;
    }

    public OpInstance<?> newInstance() {
        return OpInstance.of(this.generateOp(), this, this.info.opType());
    }

    public OpInstance<?> newInstance(Type opType) {
        return OpInstance.of(this.generateOp(), this, opType);
    }

    protected Object generateOp() {
        List dependencyInstances = this.dependencies().stream().map(d -> d.newInstance().op()).collect(Collectors.toList());
        Object op = this.info().createOpInstance(dependencyInstances).object();
        return op;
    }

    private synchronized void generateSignature() {
        if (this.id != null) {
            return;
        }
        String s = this.info().id();
        s = s.concat(String.valueOf(DEP_START_DELIM));
        for (InfoTree dependency : this.dependencies()) {
            s = s.concat(dependency.signature());
        }
        this.id = s.concat(String.valueOf(DEP_END_DELIM));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.info().implementationName());
        for (InfoTree dep : this.dependencies()) {
            sb.append(DEPENDENCY_DELIM).append(dep.toString().replace("\n", "\n\t"));
        }
        return sb.toString();
    }
}

