/*-
 * #%L
 * Java implementation of the SciJava Ops matching engine.
 * %%
 * Copyright (C) 2016 - 2024 SciJava developers.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */
/*
 * This is autogenerated source code -- DO NOT EDIT. Instead, edit the
 * corresponding template in templates/ and rerun bin/generate.groovy.
 */

package org.scijava.ops.engine.adapt.lift;

import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;

import org.scijava.function.Functions;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpCollection;

/**
 * Converts {@link Functions} operating on single types to {@link Functions}
 * that operate on {@link Iterable}s of types. N.B. it is the user's
 * responsibility to pass {@link Iterable}s of the same length (otherwise the Op
 * will stop when one of the {@link Iterable}s runs out of {@link Object}s).
 * 
 * @author Gabriel Selzer
 */
public class FunctionToIterables<I, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> implements OpCollection {

	// NOTE: we cannot convert Producers since there is no way to determine the
	// length of the output Iterable

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Function<I, O>, Function<Iterable<I>, Iterable<O>>> liftFunction1 =
		(function) -> {
			return (in1) -> lazyIterable(itrs -> function.apply((I) itrs[0].next()), in1);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<BiFunction<I1, I2, O>, BiFunction<Iterable<I1>, Iterable<I2>, Iterable<O>>> liftFunction2 =
		(function) -> {
			return (in1, in2) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next()), in1, in2);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity3<I1, I2, I3, O>, Functions.Arity3<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<O>>> liftFunction3 =
		(function) -> {
			return (in1, in2, in3) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next()), in1, in2, in3);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity4<I1, I2, I3, I4, O>, Functions.Arity4<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<O>>> liftFunction4 =
		(function) -> {
			return (in1, in2, in3, in4) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next()), in1, in2, in3, in4);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity5<I1, I2, I3, I4, I5, O>, Functions.Arity5<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<O>>> liftFunction5 =
		(function) -> {
			return (in1, in2, in3, in4, in5) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next()), in1, in2, in3, in4, in5);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity6<I1, I2, I3, I4, I5, I6, O>, Functions.Arity6<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<O>>> liftFunction6 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next()), in1, in2, in3, in4, in5, in6);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity7<I1, I2, I3, I4, I5, I6, I7, O>, Functions.Arity7<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<O>>> liftFunction7 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next()), in1, in2, in3, in4, in5, in6, in7);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O>, Functions.Arity8<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<I8>, Iterable<O>>> liftFunction8 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next(), (I8) itrs[7].next()), in1, in2, in3, in4, in5, in6, in7, in8);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O>, Functions.Arity9<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<I8>, Iterable<I9>, Iterable<O>>> liftFunction9 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next(), (I8) itrs[7].next(), (I9) itrs[8].next()), in1, in2, in3, in4, in5, in6, in7, in8, in9);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O>, Functions.Arity10<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<I8>, Iterable<I9>, Iterable<I10>, Iterable<O>>> liftFunction10 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next(), (I8) itrs[7].next(), (I9) itrs[8].next(), (I10) itrs[9].next()), in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O>, Functions.Arity11<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<I8>, Iterable<I9>, Iterable<I10>, Iterable<I11>, Iterable<O>>> liftFunction11 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next(), (I8) itrs[7].next(), (I9) itrs[8].next(), (I10) itrs[9].next(), (I11) itrs[10].next()), in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O>, Functions.Arity12<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<I8>, Iterable<I9>, Iterable<I10>, Iterable<I11>, Iterable<I12>, Iterable<O>>> liftFunction12 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next(), (I8) itrs[7].next(), (I9) itrs[8].next(), (I10) itrs[9].next(), (I11) itrs[10].next(), (I12) itrs[11].next()), in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O>, Functions.Arity13<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<I8>, Iterable<I9>, Iterable<I10>, Iterable<I11>, Iterable<I12>, Iterable<I13>, Iterable<O>>> liftFunction13 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next(), (I8) itrs[7].next(), (I9) itrs[8].next(), (I10) itrs[9].next(), (I11) itrs[10].next(), (I12) itrs[11].next(), (I13) itrs[12].next()), in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O>, Functions.Arity14<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<I8>, Iterable<I9>, Iterable<I10>, Iterable<I11>, Iterable<I12>, Iterable<I13>, Iterable<I14>, Iterable<O>>> liftFunction14 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next(), (I8) itrs[7].next(), (I9) itrs[8].next(), (I10) itrs[9].next(), (I11) itrs[10].next(), (I12) itrs[11].next(), (I13) itrs[12].next(), (I14) itrs[13].next()), in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O>, Functions.Arity15<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<I8>, Iterable<I9>, Iterable<I10>, Iterable<I11>, Iterable<I12>, Iterable<I13>, Iterable<I14>, Iterable<I15>, Iterable<O>>> liftFunction15 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next(), (I8) itrs[7].next(), (I9) itrs[8].next(), (I10) itrs[9].next(), (I11) itrs[10].next(), (I12) itrs[11].next(), (I13) itrs[12].next(), (I14) itrs[13].next(), (I15) itrs[14].next()), in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		};

	@SuppressWarnings("unchecked")
	@OpField(names = "engine.adapt")
	public final Function<Functions.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O>, Functions.Arity16<Iterable<I1>, Iterable<I2>, Iterable<I3>, Iterable<I4>, Iterable<I5>, Iterable<I6>, Iterable<I7>, Iterable<I8>, Iterable<I9>, Iterable<I10>, Iterable<I11>, Iterable<I12>, Iterable<I13>, Iterable<I14>, Iterable<I15>, Iterable<I16>, Iterable<O>>> liftFunction16 =
		(function) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> lazyIterable(itrs -> function.apply((I1) itrs[0].next(), (I2) itrs[1].next(), (I3) itrs[2].next(), (I4) itrs[3].next(), (I5) itrs[4].next(), (I6) itrs[5].next(), (I7) itrs[6].next(), (I8) itrs[7].next(), (I9) itrs[8].next(), (I10) itrs[9].next(), (I11) itrs[10].next(), (I12) itrs[11].next(), (I13) itrs[12].next(), (I14) itrs[13].next(), (I15) itrs[14].next(), (I16) itrs[15].next()), in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		};

	/**
	 * Lazily zips N {@link Iterable}s into one {@link Iterable} through the use
	 * of {@code nexter}
	 * 
	 * @param <E> - the output type of the function wrapped by {@code nexter}
	 * @param nexter a {@link Function} that wraps some other N-arity
	 *          {@link Function}. It is assumed that the arity of the wrapped
	 *          {@link Function} is equal to the length of {@code iterables}.
	 *          {@code nexter} can, given a list of {@link Iterator}s (these will
	 *          be iterators on {@code iterables}), call the wrapped function and
	 *          return the output.
	 * @param iterables the list of {@link Iterable}s that wil sequentially be
	 *          iterated over usignd {@code nexter}
	 * @return {@link Iterable} generated lazily using {@code nexter}.
	 */
	static <E> Iterable<E> lazyIterable(final Function<Iterator<?>[], E> nexter,
		final Iterable<?>... iterables)
	{
		return new Iterable<>() {

			@Override
			public Iterator<E> iterator() {
				return new Iterator<>() {

					private Iterator<?>[] iterators;
					{
						iterators = new Iterator<?>[iterables.length];
						for (int i = 0; i < iterables.length; i++)
							iterators[i] = iterables[i].iterator();
					}

					@Override
					public boolean hasNext() {
						for (Iterator<?> itr : iterators)
							if (!itr.hasNext()) return false;
						return true;
					}

					@Override
					public E next() {
						return nexter.apply(iterators);
					}

				};
			}
		};
	}
}
