/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.tamura2d;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gradient.PartialDerivative;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class DefaultDirectionalityFeature<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity2<RandomAccessibleInterval<I>, Integer, O> {
    @OpDependency(name="image.histogram")
    private BiFunction<Iterable<DoubleType>, Integer, Histogram1d<DoubleType>> histOp;
    @OpDependency(name="stats.stdDev")
    private Function<Iterable<LongType>, DoubleType> stdOp;
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, I, Img<I>> imgCreator;

    public void compute(RandomAccessibleInterval<I> input, @Nullable Integer histogramSize, O output) {
        if (input.numDimensions() != 2) {
            throw new IllegalArgumentException("Only 2 dimensional images allowed!");
        }
        if (histogramSize == null) {
            histogramSize = 16;
        }
        ArrayList<DoubleType> dirList = new ArrayList<DoubleType>();
        long[] dims = new long[input.numDimensions()];
        input.dimensions(dims);
        RealType imgType = (RealType)Views.iterable(input).firstElement();
        Img<I> derX = this.imgCreator.apply((Dimensions)input, (I)imgType);
        Img<I> derY = this.imgCreator.apply((Dimensions)input, (I)imgType);
        PartialDerivative.gradientCentralDifference2((RandomAccessible)Views.extendMirrorSingle(input), derX, (int)0);
        PartialDerivative.gradientCentralDifference2((RandomAccessible)Views.extendMirrorSingle(input), derY, (int)1);
        Cursor cX = derX.cursor();
        Cursor cY = derY.cursor();
        while (cX.hasNext()) {
            cX.next();
            cY.next();
            double dx = ((RealType)cX.get()).getRealDouble();
            double dy = ((RealType)cY.get()).getRealDouble();
            double dir = 0.0;
            double mag = 0.0;
            mag = Math.sqrt(dx * dx + dy * dy);
            if (dx == 0.0 || !(mag > 0.0)) continue;
            dir = Math.atan(dy / dx) + 1.5707963267948966;
            dirList.add(new DoubleType(dir));
        }
        if (dirList.isEmpty()) {
            output.setReal(0.0);
        } else {
            Histogram1d<DoubleType> hist = this.histOp.apply(dirList, histogramSize);
            double std = this.stdOp.apply((Iterable<LongType>)hist).getRealDouble();
            output.setReal(1.0 / std);
        }
    }
}

