/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.pad;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public abstract class PadInputFFT<T extends ComplexType<T>, I extends RandomAccessibleInterval<T>, O extends RandomAccessibleInterval<T>>
implements Functions.Arity4<I, Dimensions, Boolean, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, O> {
    @OpDependency(name="filter.padIntervalCentered")
    private BiFunction<I, Dimensions, O> paddingIntervalCentered;
    private Function<Dimensions, long[][]> fftSizeOp;

    public O apply(I input, Dimensions paddedDimensions, @Nullable Boolean fast, @Nullable OutOfBoundsFactory<T, RandomAccessibleInterval<T>> obf) {
        if (fast == null) {
            fast = true;
        }
        long[][] sizes = this.getFFTSizeOp(fast).apply(paddedDimensions);
        FinalDimensions paddedFFTInputDimensions = new FinalDimensions(sizes[0]);
        if (obf == null) {
            obf = new OutOfBoundsConstantValueFactory((Object)((ComplexType)((ComplexType)Util.getTypeFromInterval(input)).createVariable()));
        }
        Interval inputInterval = (Interval)this.paddingIntervalCentered.apply(input, (Dimensions)paddedFFTInputDimensions);
        return (O)Views.interval((RandomAccessible)Views.extend(input, (OutOfBoundsFactory)obf), (Interval)inputInterval);
    }

    protected Function<Dimensions, long[][]> getFFTSizeOp(boolean fast) {
        return this.fftSizeOp;
    }
}

