/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.invert;

import java.math.BigInteger;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.util.Util;
import org.scijava.function.Computers;
import org.scijava.ops.image.util.UnboundedIntegerType;

public class Inverters<T extends RealType<T>, I extends IntegerType<I>> {
    public final Computers.Arity3<RandomAccessibleInterval<T>, T, T, RandomAccessibleInterval<T>> delegatorInvert = (input, min, max, output) -> {
        RealType copy = (RealType)((RealType)Util.getTypeFromInterval((Interval)input)).createVariable();
        boolean typeTooBig = false;
        if (copy instanceof IntegerType) {
            ((IntegerType)copy).setInteger(Long.MAX_VALUE);
            if (((IntegerType)copy).getIntegerLong() == Long.MAX_VALUE) {
                typeTooBig = true;
            }
        }
        if (typeTooBig) {
            this.computeIIInteger((RandomAccessibleInterval<T>)input, (T)min, (T)max, (RandomAccessibleInterval<T>)output);
        } else {
            this.computeII((RandomAccessibleInterval<T>)input, (T)min, (T)max, (RandomAccessibleInterval<T>)output);
        }
    };
    public final Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> simpleInvert = (input, output) -> {
        RealType type = (RealType)Util.getTypeFromInterval((Interval)input);
        this.delegatorInvert.compute(input, (Object)Inverters.minValue(type), (Object)Inverters.maxValue(type), output);
    };

    public void computeII(RandomAccessibleInterval<T> input, T min, T max, RandomAccessibleInterval<T> output) {
        double minDouble = min.getRealDouble();
        double maxDouble = max.getRealDouble();
        double minMax = min.getRealDouble() + max.getRealDouble();
        LoopBuilder.setImages(input, output).multiThreaded().forEachPixel((in, out) -> {
            if (minMax - in.getRealDouble() <= out.getMinValue()) {
                out.setReal(out.getMinValue());
            } else if (minMax - in.getRealDouble() >= out.getMaxValue()) {
                out.setReal(out.getMaxValue());
            } else {
                out.setReal(minMax - in.getRealDouble());
            }
        });
    }

    public void computeIIInteger(RandomAccessibleInterval<T> input, T min, T max, RandomAccessibleInterval<T> output) {
        BigInteger minValue = this.getBigInteger(min);
        BigInteger maxValue = this.getBigInteger(max);
        BigInteger minMax = minValue.add(maxValue);
        LoopBuilder.setImages(input, output).multiThreaded().forEachPixel((in, out) -> {
            BigInteger inverted = minMax.subtract(this.getBigInteger(in));
            if (inverted.compareTo(this.getBigInteger(Inverters.minValue(out))) <= 0) {
                out.set((Type)Inverters.minValue(out));
            } else if (inverted.compareTo(this.getBigInteger(Inverters.maxValue(out))) >= 0) {
                out.set((Type)Inverters.maxValue(out));
            } else {
                this.setBigInteger(out, inverted);
            }
        });
    }

    private BigInteger getBigInteger(T in) {
        if (in instanceof IntegerType) {
            return ((IntegerType)in).getBigInteger();
        }
        return BigInteger.valueOf((long)in.getRealDouble());
    }

    private void setBigInteger(T out, BigInteger bi) {
        if (out instanceof IntegerType) {
            ((IntegerType)out).setBigInteger(bi);
            return;
        }
        out.setReal(bi.doubleValue());
    }

    public static <T extends RealType<T>> T minValue(T type) {
        RealType min = (RealType)type.createVariable();
        if (type instanceof UnboundedIntegerType) {
            min.setReal(0.0f);
        } else {
            min.setReal(min.getMinValue());
        }
        return (T)min;
    }

    public static <T extends RealType<T>> T maxValue(T type) {
        RealType max = (RealType)type.createVariable();
        if (max instanceof Unsigned128BitType) {
            Unsigned128BitType t = (Unsigned128BitType)max;
            t.set(t.getMaxBigIntegerValue());
        } else if (max instanceof UnsignedLongType) {
            UnsignedLongType t = (UnsignedLongType)max;
            t.set(t.getMaxBigIntegerValue());
        } else if (max instanceof UnboundedIntegerType) {
            max.setReal(0.0f);
        } else {
            max.setReal(type.getMaxValue());
        }
        return (T)max;
    }
}

