/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.rosin;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.image.threshold.AbstractComputeThresholdHistogram;

public class ComputeRosinThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T> {
    @Override
    public long computeBin(Histogram1d<T> histo) {
        long[] hist = histo.toLongArray();
        return ComputeRosinThreshold.computeBin(hist);
    }

    public static long computeBin(long[] hist) {
        int fi;
        int d2;
        int st;
        int noPts = hist.length;
        boolean doInvert = false;
        int pk = ComputeRosinThreshold.findStart(hist, noPts);
        int d1 = pk - (st = ComputeRosinThreshold.findFirst(hist, noPts));
        if (d1 > (d2 = (fi = ComputeRosinThreshold.findEnd(hist, noPts)) - pk)) {
            doInvert = true;
        }
        if (doInvert) {
            for (int i = 0; i < noPts / 2; ++i) {
                long tmp = hist[i];
                hist[i] = hist[noPts - 1 - i];
                hist[noPts - 1 - i] = tmp;
            }
        }
        st = ComputeRosinThreshold.findStart(hist, noPts);
        int thresh = ComputeRosinThreshold.findCorner(hist, st, noPts);
        if (doInvert) {
            thresh = noPts - thresh - 1;
        }
        return thresh;
    }

    private static int findStart(long[] Y, int noPts) {
        int st = 0;
        long max = Y[0];
        for (int i = 1; i < noPts; ++i) {
            if (Y[i] <= max) continue;
            max = Y[i];
            st = i;
        }
        return st;
    }

    private static int findFirst(long[] Y, int noPts) {
        int st = 0;
        for (int i = 0; i < noPts; ++i) {
            if (Y[i] <= 0L) continue;
            st = i;
            break;
        }
        return st;
    }

    private static int findEnd(long[] Y, int noPts) {
        int fi = 0;
        for (int i = 1; i < noPts; ++i) {
            if (Y[i] <= 0L) continue;
            fi = i;
        }
        return fi;
    }

    private static int findCorner(long[] Y, int st, int noPts) {
        int end;
        int i;
        long[] X = new long[noPts];
        float maxDist = -1.0f;
        int thresh = -1;
        for (i = st; i < noPts; ++i) {
            X[i] = i;
        }
        for (end = noPts - 1; Y[end] == 0L && end >= 0; --end) {
        }
        noPts = end;
        if (end <= 0) {
            throw new IllegalStateException("Histogram is empty.");
        }
        for (i = st; i <= noPts; ++i) {
            float dist = (Y[st] - Y[noPts - 1]) * X[i] - (X[st] - X[noPts - 1]) * Y[i] - X[noPts - 1] * Y[st] + X[st] * Y[noPts - 1];
            dist = (float)(Math.pow(dist, 2.0) / (Math.pow(X[st] - X[noPts - 1], 2.0) + Math.pow(Y[st] - Y[noPts - 1], 2.0)));
            if (!((dist = Math.abs(dist)) > maxDist)) continue;
            maxDist = dist;
            thresh = i;
        }
        return thresh;
    }
}

