/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.testutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class ArrayIO {
    private ArrayIO() {
    }

    public static byte[] bytes(InputStream is) throws IOException {
        return is.readAllBytes();
    }

    public static double[] doubles(InputStream is) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(is.readAllBytes());
        DoubleBuffer view = bb.asDoubleBuffer();
        return DoubleBuffer.allocate(view.limit()).put(view).array();
    }

    public static float[] floats(InputStream is) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(is.readAllBytes());
        FloatBuffer view = bb.asFloatBuffer();
        return FloatBuffer.allocate(view.limit()).put(view).array();
    }

    public static int[] ints(InputStream is) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(is.readAllBytes());
        IntBuffer view = bb.asIntBuffer();
        return IntBuffer.allocate(view.limit()).put(view).array();
    }

    public static long[] longs(InputStream is) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(is.readAllBytes());
        LongBuffer view = bb.asLongBuffer();
        return LongBuffer.allocate(view.limit()).put(view).array();
    }

    public static short[] shorts(InputStream is) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(is.readAllBytes());
        ShortBuffer view = bb.asShortBuffer();
        return ShortBuffer.allocate(view.limit()).put(view).array();
    }

    public static void writeBytes(byte[] data, OutputStream os) throws IOException {
        os.write(data);
    }

    public static void writeDoubles(double[] data, OutputStream os) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4 * data.length);
        bb.asDoubleBuffer().put(DoubleBuffer.wrap(data));
        os.write(bb.array());
    }

    public static void writeFloats(float[] data, OutputStream os) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4 * data.length);
        bb.asFloatBuffer().put(FloatBuffer.wrap(data));
        os.write(bb.array());
    }

    public static void writeInts(int[] data, OutputStream os) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4 * data.length);
        bb.asIntBuffer().put(IntBuffer.wrap(data));
        os.write(bb.array());
    }

    public static void writeLongs(long[] data, OutputStream os) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8 * data.length);
        bb.asLongBuffer().put(LongBuffer.wrap(data));
        os.write(bb.array());
    }

    public static void writeShorts(short[] data, OutputStream os) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4 * data.length);
        bb.asShortBuffer().put(ShortBuffer.wrap(data));
        os.write(bb.array());
    }
}

