/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.matcher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.java.matcher.MethodMatcher;

public class MethodMatcherFactory {
    private static final Pattern CLASS_PATTERN = Pattern.compile("^(\\w+[\\.\\w+]*(?:\\[\\])?)(\\()?");
    private static final Pattern METHOD_PATTERN = Pattern.compile("^([a-zA-Z_0-9\\$]+[\\.[a-zA-Z_0-9\\$]+]*(?:\\[\\])?)#(\\w+)(\\()?");
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile("\\G(\\w+[\\.\\w+]*(?:\\[\\])?)([,\\)])");

    private MethodMatcherFactory() {
    }

    public static MethodMatcher constructorMatcher(String descriptor) {
        Matcher matcher = CLASS_PATTERN.matcher(descriptor);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Illegal constructor specification: " + descriptor);
        }
        MethodMatcher constructorMatcher = MethodMatcher.create().typeDefinition(matcher.group(1)).name("<init>");
        MethodMatcherFactory.collectArguments(descriptor, matcher, 2, constructorMatcher);
        return constructorMatcher;
    }

    public static MethodMatcher methodMatcher(String descriptor) {
        Matcher matcher = METHOD_PATTERN.matcher(descriptor);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Illegal method specification: " + descriptor);
        }
        MethodMatcher methodMatcher = MethodMatcher.create().typeDefinition(matcher.group(1)).name(matcher.group(2));
        MethodMatcherFactory.collectArguments(descriptor, matcher, 3, methodMatcher);
        return methodMatcher;
    }

    public static void collectArguments(String descriptor, Matcher initialMatcher, int groupOffset, MethodMatcher methodMatcher) {
        if ("(".equals(initialMatcher.group(groupOffset))) {
            String remainder = descriptor.substring(initialMatcher.group().length());
            if (!")".equals(remainder)) {
                Matcher matcher = ARGUMENT_PATTERN.matcher(remainder);
                int matchedLength = 0;
                while (matcher.find()) {
                    methodMatcher.addParameter(matcher.group(1));
                    matchedLength = matcher.end();
                }
                if (matchedLength < remainder.length()) {
                    throw new IllegalArgumentException("Illegal method or constructor arguments specification: " + descriptor);
                }
            }
        } else {
            if (initialMatcher.end() < descriptor.length()) {
                throw new IllegalArgumentException("Illegal method or constructor arguments specification: " + descriptor);
            }
            methodMatcher.withNoParameterConstraint();
        }
    }
}

