/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.model.statement.BlockTreeImpl;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class CatchTreeImpl
extends JavaTree
implements CatchTree {
    private final InternalSyntaxToken catchToken;
    private final InternalSyntaxToken openParenToken;
    private final VariableTree parameter;
    private final BlockTree block;
    private final InternalSyntaxToken closeParenToken;

    public CatchTreeImpl(InternalSyntaxToken catchToken, InternalSyntaxToken openParenToken, VariableTreeImpl parameter, InternalSyntaxToken closeParenToken, BlockTreeImpl block) {
        super(Tree.Kind.CATCH);
        this.catchToken = catchToken;
        this.openParenToken = openParenToken;
        this.parameter = (VariableTree)Preconditions.checkNotNull((Object)parameter);
        this.closeParenToken = closeParenToken;
        this.block = (BlockTree)Preconditions.checkNotNull((Object)block);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.CATCH;
    }

    @Override
    public SyntaxToken catchKeyword() {
        return this.catchToken;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public VariableTree parameter() {
        return this.parameter;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public BlockTree block() {
        return this.block;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCatch(this);
    }

    @Override
    public Iterable<Tree> children() {
        return Lists.newArrayList((Object[])new Tree[]{this.catchToken, this.openParenToken, this.parameter, this.closeParenToken, this.block});
    }
}

