/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.util.ArrayList;
import java.util.List;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class CheckerDispatcher
implements CheckerContext {
    private final ExplodedGraphWalker explodedGraphWalker;
    private final List<SECheck> checks;
    private Tree syntaxNode;
    private int currentCheckerIndex = -1;
    private boolean transition = false;

    public CheckerDispatcher(ExplodedGraphWalker explodedGraphWalker, List<SECheck> checks) {
        this.explodedGraphWalker = explodedGraphWalker;
        this.checks = checks;
    }

    public boolean executeCheckPreStatement(Tree syntaxNode) {
        this.syntaxNode = syntaxNode;
        for (SECheck checker : this.checks) {
            ProgramState ps = checker.checkPreStatement(this, syntaxNode);
            if (ps == null) {
                return false;
            }
            this.explodedGraphWalker.programState = ps;
        }
        return true;
    }

    public void executeCheckPostStatement(Tree syntaxNode) {
        this.syntaxNode = syntaxNode;
        this.addTransition(this.explodedGraphWalker.programState);
    }

    @Override
    public ProgramState getState() {
        return this.explodedGraphWalker.programState;
    }

    @Override
    public void reportIssue(Tree tree, SECheck check, String message) {
        this.reportIssue(tree, check, message, new ArrayList<JavaFileScannerContext.Location>());
    }

    @Override
    public void reportIssue(Tree tree, SECheck check, String message, List<JavaFileScannerContext.Location> locations) {
        check.reportIssue(tree, message, locations);
    }

    @Override
    public void addTransition(ProgramState state) {
        ProgramState oldState = this.explodedGraphWalker.programState;
        this.explodedGraphWalker.programState = state;
        ++this.currentCheckerIndex;
        this.executePost();
        --this.currentCheckerIndex;
        this.explodedGraphWalker.programState = oldState;
        this.transition = true;
    }

    private void executePost() {
        this.transition = false;
        if (this.currentCheckerIndex >= this.checks.size()) {
            if (this.explodedGraphWalker.programPosition.i < this.explodedGraphWalker.programPosition.block.elements().size()) {
                this.explodedGraphWalker.clearStack(this.explodedGraphWalker.programPosition.block.elements().get(this.explodedGraphWalker.programPosition.i));
            }
            this.explodedGraphWalker.enqueue(new ExplodedGraph.ProgramPoint(this.explodedGraphWalker.programPosition.block, this.explodedGraphWalker.programPosition.i + 1), this.explodedGraphWalker.programState, this.explodedGraphWalker.node.exitPath);
            return;
        }
        this.explodedGraphWalker.programState = this.checks.get(this.currentCheckerIndex).checkPostStatement(this, this.syntaxNode);
        if (!this.transition) {
            this.addTransition(this.explodedGraphWalker.programState);
        }
    }

    @Override
    public Object createSink() {
        this.transition = true;
        return new Object();
    }

    public void executeCheckEndOfExecution() {
        for (SECheck checker : this.checks) {
            checker.checkEndOfExecution(this);
        }
    }

    public void executeCheckEndOfExecutionPath(ConstraintManager constraintManager) {
        for (SECheck checker : this.checks) {
            checker.checkEndOfExecutionPath(this, constraintManager);
        }
    }

    public void init(MethodTree methodTree, CFG cfg) {
        for (SECheck checker : this.checks) {
            checker.init(methodTree, cfg);
        }
    }

    @Override
    public ConstraintManager getConstraintManager() {
        return this.explodedGraphWalker.constraintManager;
    }
}

