/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.SyntaxTreeNameFinder;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2259")
public class NullDereferenceCheck
extends SECheck {
    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        SymbolicValue currentVal = context.getState().peekValue();
        if (currentVal == null) {
            return context.getState();
        }
        Tree toCheck = syntaxNode;
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)syntaxNode;
            toCheck = methodInvocation.methodSelect();
            if (NullDereferenceCheck.isObjectsRequireNonNullMethod(methodInvocation.symbol())) {
                int numberArguments = methodInvocation.arguments().size();
                List<SymbolicValue> values = context.getState().peekValues(numberArguments + 1);
                return context.getState().addConstraint(values.get(numberArguments), ObjectConstraint.NOT_NULL);
            }
        }
        if (toCheck.is(Tree.Kind.MEMBER_SELECT)) {
            return this.checkMemberSelect(context, (MemberSelectExpressionTree)toCheck, currentVal);
        }
        return context.getState();
    }

    private static boolean isObjectsRequireNonNullMethod(Symbol symbol) {
        return symbol.isMethodSymbol() && symbol.owner().type().is("java.util.Objects") && "requireNonNull".equals(symbol.name());
    }

    private ProgramState checkMemberSelect(CheckerContext context, MemberSelectExpressionTree syntaxNode, SymbolicValue currentVal) {
        ProgramState programState = context.getState();
        if ("class".equals(syntaxNode.identifier().name())) {
            return programState;
        }
        Constraint constraint = programState.getConstraint(currentVal);
        if (constraint != null && constraint.isNull()) {
            ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>();
            if (((ObjectConstraint)constraint).syntaxNode() != null) {
                secondary.add(new JavaFileScannerContext.Location("", ((ObjectConstraint)constraint).syntaxNode()));
            }
            context.reportIssue(syntaxNode, this, "NullPointerException might be thrown as '" + SyntaxTreeNameFinder.getName(syntaxNode) + "' is nullable here", secondary);
            return null;
        }
        SymbolicValue targetValue = programState.peekValue();
        constraint = programState.getConstraint(targetValue);
        if (constraint == null) {
            return programState.addConstraint(targetValue, ObjectConstraint.NOT_NULL);
        }
        return programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT) && context.getConstraintManager().isNull(context.getState(), context.getState().peekValue())) {
            context.reportIssue(syntaxNode, this, "NullPointerException might be thrown as '" + SyntaxTreeNameFinder.getName(syntaxNode) + "' is nullable here");
            context.createSink();
            return context.getState();
        }
        List<ProgramState> programStates = NullDereferenceCheck.setNullConstraint(context, syntaxNode);
        for (ProgramState programState : programStates) {
            context.addTransition(programState);
        }
        return context.getState();
    }

    private static List<ProgramState> setNullConstraint(CheckerContext context, Tree syntaxNode) {
        SymbolicValue val = context.getState().peekValue();
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION) && NullDereferenceCheck.isAnnotatedCheckForNull((MethodInvocationTree)syntaxNode)) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.nullConstraint(syntaxNode)));
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.NOT_NULL));
            return states;
        }
        return Lists.newArrayList((Object[])new ProgramState[]{context.getState()});
    }

    private static boolean isAnnotatedCheckForNull(MethodInvocationTree syntaxNode) {
        return syntaxNode.symbol().metadata().isAnnotatedWith("javax.annotation.CheckForNull");
    }
}

