/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.constraint;

import javax.annotation.Nullable;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.plugins.java.api.tree.Tree;

public class ObjectConstraint
implements Constraint {
    public static final ObjectConstraint NOT_NULL = new ObjectConstraint(false, true, null, null);
    private final boolean isNull;
    private final boolean disposable;
    private final Tree syntaxNode;
    @Nullable
    private final Object status;

    public ObjectConstraint(Tree syntaxNode, Object status) {
        this(false, true, syntaxNode, status);
    }

    public ObjectConstraint(boolean isNull, boolean disposable, @Nullable Tree syntaxNode, @Nullable Object status) {
        this.isNull = isNull;
        this.disposable = disposable;
        this.syntaxNode = syntaxNode;
        this.status = status;
    }

    public static ObjectConstraint nullConstraint() {
        return ObjectConstraint.nullConstraint(null);
    }

    public static ObjectConstraint nullConstraint(@Nullable Tree syntaxNode) {
        return new ObjectConstraint(true, false, syntaxNode, null);
    }

    public ObjectConstraint inverse() {
        return new ObjectConstraint(!this.isNull, this.disposable, this.syntaxNode, this.status);
    }

    public ObjectConstraint withStatus(Object newStatus) {
        return new ObjectConstraint(this.isNull, this.disposable, this.syntaxNode, newStatus);
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    public boolean isInvalidWith(@Nullable Constraint target) {
        return false;
    }

    public boolean isDisposable() {
        return this.disposable;
    }

    public boolean hasStatus(@Nullable Object aState) {
        if (aState == null) {
            return this.status == null;
        }
        return aState.equals(this.status);
    }

    public Tree syntaxNode() {
        return this.syntaxNode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.isNull ? "NULL" : "NOT_NULL");
        if (this.status != null) {
            buffer.append('(');
            buffer.append(this.status);
            buffer.append(')');
        }
        return buffer.toString();
    }
}

