/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.EqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanRelation;
import org.sonar.java.se.symbolicvalues.LessThanRelation;
import org.sonar.java.se.symbolicvalues.MethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.NotEqualRelation;
import org.sonar.java.se.symbolicvalues.NotMethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class LessThanOrEqualRelation
extends BinaryRelation {
    LessThanOrEqualRelation(SymbolicValue v1, SymbolicValue v2) {
        super(RelationalSymbolicValue.Kind.LESS_THAN_OR_EQUAL, v1, v2);
    }

    @Override
    protected RelationState isImpliedBy(BinaryRelation relation) {
        return relation.impliesLessThanOrEqual();
    }

    @Override
    protected RelationState impliesEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesNotEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesMethodEquals() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesNotMethodEquals() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesGreaterThan() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThanOrEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesLessThan() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesLessThanOrEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected BinaryRelation combinedAfter(BinaryRelation relation) {
        return relation.combinedWithLessThanOrEqual(this);
    }

    @Override
    protected BinaryRelation combinedWithEqual(EqualRelation relation) {
        return LessThanOrEqualRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN_OR_EQUAL, this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotEqual(NotEqualRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithMethodEquals(MethodEqualsRelation relation) {
        return LessThanOrEqualRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN_OR_EQUAL, this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotMethodEquals(NotMethodEqualsRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithGreaterThan(GreaterThanRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithGreaterThanOrEqual(GreaterThanOrEqualRelation relation) {
        return null;
    }

    @Override
    protected BinaryRelation combinedWithLessThan(LessThanRelation relation) {
        return LessThanOrEqualRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN, this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithLessThanOrEqual(LessThanOrEqualRelation relation) {
        return LessThanOrEqualRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN_OR_EQUAL, this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation conjunction(BinaryRelation relation) {
        Preconditions.checkArgument((this.leftOp.equals(relation.leftOp) && this.rightOp.equals(relation.rightOp) ? 1 : 0) != 0, (Object)"Conjunction condition not matched!");
        switch (relation.kind) {
            case NOT_EQUAL: 
            case NOT_METHOD_EQUALS: {
                return LessThanOrEqualRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN, this.leftOp, this.rightOp);
            }
            case GREATER_THAN_OR_EQUAL: {
                return LessThanOrEqualRelation.binaryRelation(RelationalSymbolicValue.Kind.EQUAL, this.leftOp, this.rightOp);
            }
        }
        return super.conjunction(relation);
    }
}

