/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.util.Collection;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JacocoConfiguration;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class JaCoCoItSensor
implements Sensor {
    private final JacocoConfiguration configuration;
    private final ResourcePerspectives perspectives;
    private final FileSystem fileSystem;
    private final PathResolver pathResolver;
    private final JavaResourceLocator javaResourceLocator;
    private final JavaClasspath javaClasspath;

    public JaCoCoItSensor(JacocoConfiguration configuration, ResourcePerspectives perspectives, FileSystem fileSystem, PathResolver pathResolver, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath) {
        this.configuration = configuration;
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.javaResourceLocator = javaResourceLocator;
        this.javaClasspath = javaClasspath;
    }

    public boolean shouldExecuteOnProject(Project project) {
        File report = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getItReportPath());
        boolean foundReport = report.isFile();
        if (!foundReport) {
            JaCoCoExtensions.LOG.info("JaCoCoItSensor: JaCoCo IT report not found: " + report.getPath());
        }
        return this.configuration.shouldExecuteOnProject(foundReport);
    }

    public void analyse(Project project, SensorContext context) {
        new ITAnalyzer(this.perspectives).analyse(project, context);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    class ITAnalyzer
    extends AbstractAnalyzer {
        public ITAnalyzer(ResourcePerspectives perspectives) {
            super(perspectives, JaCoCoItSensor.this.fileSystem, JaCoCoItSensor.this.pathResolver, JaCoCoItSensor.this.javaResourceLocator, JaCoCoItSensor.this.javaClasspath);
        }

        @Override
        protected String getReportPath(Project project) {
            return JaCoCoItSensor.this.configuration.getItReportPath();
        }

        @Override
        protected void saveMeasures(SensorContext context, Resource resource, Collection<Measure> measures) {
            for (Measure measure : measures) {
                Measure itMeasure = this.convertForIT(measure);
                if (itMeasure == null) continue;
                context.saveMeasure(resource, itMeasure);
            }
        }

        private Measure convertForIT(Measure measure) {
            Measure itMeasure = null;
            if (CoreMetrics.LINES_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_LINES_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_LINES, measure.getValue());
            } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_COVERAGE_LINE_HITS_DATA, measure.getData());
            } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_CONDITIONS, measure.getValue());
            } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_COVERED_CONDITIONS_BY_LINE, measure.getData());
            } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_BY_LINE, measure.getData());
            }
            return itMeasure;
        }
    }
}

