/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.config.Settings;
import org.sonar.api.design.Dependency;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.graph.DirectedGraph;
import org.sonar.java.JavaSquid;
import org.sonar.java.SonarComponents;
import org.sonar.java.bytecode.visitor.ResourceMapping;
import org.sonar.plugins.java.bridges.ChecksBridge;
import org.sonar.plugins.java.bridges.DesignBridge;
import org.sonar.squidbridge.api.SourceFile;

public class Bridges {
    private static final Logger LOG = LoggerFactory.getLogger(Bridges.class);
    private final JavaSquid squid;
    private final Settings settings;

    public Bridges(JavaSquid squid, Settings settings) {
        this.squid = squid;
        this.settings = settings;
    }

    public void save(SensorContext context, Project project, SonarComponents sonarComponents, ResourceMapping resourceMapping, NoSonarFilter noSonarFilter, RulesProfile rulesProfile) {
        boolean skipPackageDesignAnalysis = this.settings.getBoolean("sonar.skipPackageDesign");
        if (!skipPackageDesignAnalysis && this.squid.isBytecodeScanned()) {
            DesignBridge designBridge = new DesignBridge(context, (DirectedGraph<Resource, Dependency>)this.squid.getGraph(), resourceMapping, sonarComponents.getResourcePerspectives());
            designBridge.saveDesign(project);
        }
        ChecksBridge checksBridge = new ChecksBridge(sonarComponents);
        this.reportIssues(resourceMapping, noSonarFilter, checksBridge, project);
    }

    private void reportIssues(ResourceMapping resourceMapping, NoSonarFilter noSonarFilter, ChecksBridge checksBridge, Project project) {
        for (Resource directory : resourceMapping.directories()) {
            for (Resource sonarFile : resourceMapping.files((Directory)directory)) {
                String key = resourceMapping.getFileKeyByResource((File)sonarFile);
                if (key == null) continue;
                SourceFile squidFile = (SourceFile)this.squid.search(key);
                if (squidFile != null) {
                    noSonarFilter.addResource(sonarFile, squidFile.getNoSonarTagLines());
                    checksBridge.reportIssues(squidFile, sonarFile);
                    continue;
                }
                LOG.error("Could not report issue on file: " + sonarFile.getKey());
            }
        }
    }
}

