/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.javascript.se.SymbolicValue;
import org.sonar.javascript.se.Truthiness;
import org.sonar.plugins.javascript.api.symbols.Symbol;

public class ProgramState {
    private final ImmutableMap<Symbol, SymbolicValue> valuesBySymbol;
    private static final ProgramState EMPTY = new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.of());

    public static ProgramState emptyState() {
        return EMPTY;
    }

    private ProgramState(ImmutableMap<Symbol, SymbolicValue> valuesBySymbol) {
        this.valuesBySymbol = valuesBySymbol;
    }

    public ProgramState copyAndAddValue(Symbol symbol, SymbolicValue value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.valuesBySymbol.entrySet()) {
            if (((Symbol)entry.getKey()).equals(symbol)) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        builder.put((Object)symbol, (Object)value);
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)builder.build());
    }

    public SymbolicValue get(Symbol symbol) {
        return (SymbolicValue)this.valuesBySymbol.get((Object)symbol);
    }

    public ProgramState constrain(Symbol symbol, Truthiness truthiness) {
        SymbolicValue value = this.get(symbol);
        if (value == null) {
            return this;
        }
        return this.copyAndAddValue(symbol, value.constrain(truthiness));
    }

    public int hashCode() {
        return this.valuesBySymbol.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProgramState other = (ProgramState)obj;
        return this.valuesBySymbol.equals(other.valuesBySymbol);
    }
}

