/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

public final class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(List<? extends Tree> leftList, List<? extends Tree> rightList) {
        if (leftList.size() != rightList.size() || leftList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < leftList.size(); ++i) {
            Tree right;
            Tree left = leftList.get(i);
            if (SyntacticEquivalence.areEquivalent(left, right = rightList.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(@Nullable Tree leftNode, @Nullable Tree rightNode) {
        return SyntacticEquivalence.areEquivalent((JavaScriptTree)leftNode, (JavaScriptTree)rightNode);
    }

    private static boolean areEquivalent(@Nullable JavaScriptTree leftNode, @Nullable JavaScriptTree rightNode) {
        if (leftNode == rightNode) {
            return true;
        }
        if (leftNode == null || rightNode == null) {
            return false;
        }
        if (leftNode.getKind() != rightNode.getKind()) {
            return false;
        }
        if (leftNode.isLeaf()) {
            return SyntacticEquivalence.areLeafsEquivalent(leftNode, rightNode);
        }
        Iterator<Tree> iteratorA = leftNode.childrenIterator();
        Iterator<Tree> iteratorB = rightNode.childrenIterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            if (SyntacticEquivalence.areEquivalent(iteratorA.next(), iteratorB.next())) continue;
            return false;
        }
        return !iteratorA.hasNext() && !iteratorB.hasNext();
    }

    @VisibleForTesting
    protected static boolean areLeafsEquivalent(JavaScriptTree leftNode, JavaScriptTree rightNode) {
        if (leftNode instanceof IdentifierTree) {
            return Objects.equal((Object)((IdentifierTree)((Object)leftNode)).name(), (Object)((IdentifierTree)((Object)rightNode)).name());
        }
        if (leftNode instanceof SyntaxToken) {
            return Objects.equal((Object)((SyntaxToken)((Object)leftNode)).text(), (Object)((SyntaxToken)((Object)rightNode)).text());
        }
        throw new IllegalArgumentException();
    }
}

