/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.cfg;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraphBuilder;
import org.sonar.javascript.cfg.JsCfgBlock;
import org.sonar.javascript.cfg.JsCfgBranchingBlock;
import org.sonar.javascript.cfg.JsCfgEndBlock;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;

public class ControlFlowGraph {
    private final CfgBlock start;
    private final JsCfgEndBlock end;
    private final Set<JsCfgBlock> blocks;

    ControlFlowGraph(Set<JsCfgBlock> blocks, CfgBlock start, JsCfgEndBlock end) {
        this.start = start;
        this.end = end;
        this.blocks = blocks;
        for (JsCfgBlock block : blocks) {
            for (CfgBlock successor : block.successors()) {
                ((JsCfgBlock)successor).addPredecessor(block);
            }
        }
    }

    public static ControlFlowGraph build(ScriptTree tree) {
        return new ControlFlowGraphBuilder().createGraph(tree);
    }

    public static ControlFlowGraph build(BlockTree body) {
        return new ControlFlowGraphBuilder().createGraph(body);
    }

    public CfgBlock start() {
        return this.start;
    }

    public CfgBlock end() {
        return this.end;
    }

    public Set<CfgBlock> blocks() {
        return Collections.unmodifiableSet(this.blocks);
    }

    public Set<CfgBlock> unreachableBlocks() {
        HashSet<CfgBlock> unreachable = new HashSet<CfgBlock>();
        for (CfgBlock cfgBlock : this.blocks) {
            if (cfgBlock.equals(this.start) || !cfgBlock.predecessors().isEmpty()) continue;
            unreachable.add(cfgBlock);
        }
        return unreachable;
    }

    public Set<SyntaxToken> disconnectingJumps(CfgBlock block) {
        return ((JsCfgBlock)block).disconnectingJumps();
    }

    static CfgBlock trueSuccessorFor(CfgBlock block) {
        if (block instanceof CfgBranchingBlock) {
            return ((JsCfgBranchingBlock)block).trueSuccessor();
        }
        return block.successors().iterator().next();
    }

    static CfgBlock falseSuccessorFor(CfgBlock block) {
        if (block instanceof CfgBranchingBlock) {
            return ((JsCfgBranchingBlock)block).falseSuccessor();
        }
        return block.successors().iterator().next();
    }
}

