/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

public enum Nullability {
    NULL(State.YES, State.NO, State.YES),
    NOT_NULL(State.NO, State.UNKNOWN, State.UNKNOWN),
    UNDEFINED(State.NO, State.YES, State.YES),
    NOT_UNDEFINED(State.UNKNOWN, State.NO, State.UNKNOWN),
    NULLY(State.UNKNOWN, State.UNKNOWN, State.YES),
    UNKNOWN(State.UNKNOWN, State.UNKNOWN, State.UNKNOWN),
    NOT_NULLY(State.NO, State.NO, State.NO);

    private State nullState;
    private State undefinedState;
    private State nullOrUndefined;

    private Nullability(State nullState, State undefinedState, State nullOrUndefined) {
        this.nullState = nullState;
        this.undefinedState = undefinedState;
        this.nullOrUndefined = nullOrUndefined;
    }

    public boolean isNullOrUndefined() {
        return this.nullState == State.YES || this.undefinedState == State.YES || this.nullOrUndefined == State.YES;
    }

    public boolean isNeitherNullNorUndefined() {
        return this.nullState == State.NO && this.undefinedState == State.NO && this.nullOrUndefined == State.NO;
    }

    public boolean canNotBeEqual(Nullability other) {
        return this.nullState.opposite(other.nullState) || this.undefinedState.opposite(other.undefinedState) || this.nullOrUndefined.opposite(other.nullOrUndefined);
    }

    private static enum State {
        YES,
        NO,
        UNKNOWN;


        boolean opposite(State other) {
            return this == YES && other == NO || this == NO && other == YES;
        }
    }
}

