/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.sonar.javascript.se.Nullability;
import org.sonar.javascript.se.Truthiness;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;

public class SymbolicValue {
    public static final SymbolicValue NULL = new SymbolicValue(Nullability.NULL, Truthiness.FALSY);
    public static final SymbolicValue UNDEFINED = new SymbolicValue(Nullability.UNDEFINED, Truthiness.FALSY);
    public static final SymbolicValue NOT_UNDEFINED = new SymbolicValue(Nullability.NOT_UNDEFINED, Truthiness.UNKNOWN);
    public static final SymbolicValue NULL_OR_UNDEFINED = new SymbolicValue(Nullability.NULLY, Truthiness.FALSY);
    public static final SymbolicValue UNKNOWN = new SymbolicValue(Nullability.UNKNOWN, Truthiness.UNKNOWN);
    public static final SymbolicValue NOT_NULLY = new SymbolicValue(Nullability.NOT_NULLY, Truthiness.UNKNOWN);
    public static final SymbolicValue NOT_NULL = new SymbolicValue(Nullability.NOT_NULL, Truthiness.UNKNOWN);
    @VisibleForTesting
    protected static final SymbolicValue TRUTHY_LITERAL = new SymbolicValue(Nullability.NOT_NULLY, Truthiness.TRUTHY);
    @VisibleForTesting
    protected static final SymbolicValue FALSY_LITERAL = new SymbolicValue(Nullability.NOT_NULLY, Truthiness.FALSY);
    private static final Map<SymbolicValue, String> NAMES = new ImmutableMap.Builder().put((Object)NULL, (Object)"NULL").put((Object)UNDEFINED, (Object)"UNDEFINED").put((Object)NOT_UNDEFINED, (Object)"NOT_UNDEFINED").put((Object)NULL_OR_UNDEFINED, (Object)"NULLY").put((Object)UNKNOWN, (Object)"UNKNOWN").put((Object)NOT_NULL, (Object)"NOT_NULL").put((Object)TRUTHY_LITERAL, (Object)"TRUTHY").put((Object)FALSY_LITERAL, (Object)"FALSY").build();
    private final Nullability nullability;
    private final Truthiness truthiness;

    private SymbolicValue(Nullability nullability, Truthiness truthiness) {
        this.nullability = nullability;
        this.truthiness = truthiness;
    }

    public static SymbolicValue get(ExpressionTree expression) {
        IdentifierTree identifier;
        SymbolicValue value = UNKNOWN;
        if (expression.is(Tree.Kind.NULL_LITERAL)) {
            value = NULL;
        } else if (expression.is(Tree.Kind.BOOLEAN_LITERAL)) {
            value = SymbolicValue.booleanLiteral((LiteralTree)expression);
        } else if (expression.is(Tree.Kind.STRING_LITERAL)) {
            value = SymbolicValue.stringLiteral((LiteralTree)expression);
        } else if (expression.is(Tree.Kind.NUMERIC_LITERAL)) {
            value = SymbolicValue.numericLiteral((LiteralTree)expression);
        } else if (expression.is(Tree.Kind.IDENTIFIER_REFERENCE) && "undefined".equals((identifier = (IdentifierTree)expression).name())) {
            value = UNDEFINED;
        }
        return value;
    }

    private static SymbolicValue booleanLiteral(LiteralTree expression) {
        return SymbolicValue.literal("true".equals(expression.value()));
    }

    private static SymbolicValue stringLiteral(LiteralTree expression) {
        return SymbolicValue.literal(expression.value().length() > 2);
    }

    private static SymbolicValue numericLiteral(LiteralTree expression) {
        String stringValue = expression.value();
        if (stringValue.startsWith("0x") || stringValue.startsWith("0b") || stringValue.startsWith("0o") || stringValue.startsWith("0O")) {
            return SymbolicValue.literal(SymbolicValue.hasNonZero(stringValue.substring(2)));
        }
        int exponentIndex = stringValue.indexOf(101);
        if (exponentIndex == -1) {
            exponentIndex = stringValue.indexOf(69);
        }
        if (exponentIndex > -1) {
            stringValue = stringValue.substring(0, exponentIndex);
        }
        return SymbolicValue.literal(SymbolicValue.hasNonZero(stringValue));
    }

    private static boolean hasNonZero(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '0' || c == '.') continue;
            return true;
        }
        return false;
    }

    public static SymbolicValue literal(boolean isTruthy) {
        return isTruthy ? TRUTHY_LITERAL : FALSY_LITERAL;
    }

    public Nullability nullability() {
        return this.nullability;
    }

    public Truthiness truthiness() {
        return this.truthiness;
    }

    public SymbolicValue constrain(Truthiness truthiness) {
        Nullability newNullability = this.nullability;
        if (truthiness.equals((Object)Truthiness.TRUTHY)) {
            newNullability = Nullability.NOT_NULLY;
        }
        return new SymbolicValue(newNullability, truthiness);
    }

    public SymbolicValue constrain(Nullability nullability) {
        Truthiness newTruthiness = this.truthiness;
        if (nullability.isNullOrUndefined()) {
            newTruthiness = Truthiness.FALSY;
        }
        return new SymbolicValue(nullability, newTruthiness);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nullability, this.truthiness});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolicValue other = (SymbolicValue)obj;
        return Objects.equals((Object)this.nullability, (Object)other.nullability) && Objects.equals((Object)this.truthiness, (Object)other.truthiness);
    }

    public String toString() {
        if (NAMES.containsKey(this)) {
            return NAMES.get(this);
        }
        if (this.nullability.equals((Object)Nullability.NOT_NULLY) && this.truthiness.equals((Object)Truthiness.UNKNOWN)) {
            return "NOT_NULLY";
        }
        return (Object)((Object)this.nullability) + "_" + (Object)((Object)this.truthiness);
    }
}

