/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.declaration.ParameterListTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ArrowFunctionTreeImpl
extends JavaScriptTree
implements ArrowFunctionTree,
TypableTree {
    private final Tree parameters;
    private final SyntaxToken doubleArrow;
    private Tree body;
    private Type functionType;

    public ArrowFunctionTreeImpl(Tree parameters, InternalSyntaxToken doubleArrow, Tree body) {
        this.parameters = parameters;
        this.doubleArrow = doubleArrow;
        this.body = body;
        this.functionType = FunctionType.create(this);
    }

    @Override
    public Tree parameterClause() {
        return this.parameters;
    }

    @Override
    public SyntaxToken doubleArrow() {
        return this.doubleArrow;
    }

    @Override
    public Tree body() {
        return this.body;
    }

    @Override
    public List<Tree> parameterList() {
        if (this.parameters.is(Tree.Kind.FORMAL_PARAMETER_LIST)) {
            return ((ParameterListTree)this.parameters).parameters();
        }
        return ImmutableList.of((Object)this.parameterClause());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARROW_FUNCTION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.parameters, this.doubleArrow, this.body});
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitArrowFunction(this);
    }

    public List<IdentifierTree> parameterIdentifiers() {
        if (this.parameters.is(Tree.Kind.BINDING_IDENTIFIER)) {
            return ImmutableList.of((Object)((IdentifierTree)this.parameters));
        }
        return ((ParameterListTreeImpl)this.parameters).parameterIdentifiers();
    }

    @Override
    public TypeSet types() {
        TypeSet set = TypeSet.emptyTypeSet();
        set.add(this.functionType);
        return set;
    }

    @Override
    public void add(Type type) {
        throw new UnsupportedOperationException();
    }
}

