/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class BreakStatementTreeImpl
extends JavaScriptTree
implements BreakStatementTree {
    private SyntaxToken breakKeyword;
    private final IdentifierTree label;
    private final SyntaxToken semicolonToken;

    public BreakStatementTreeImpl(SyntaxToken semicolonToken) {
        this.label = null;
        this.semicolonToken = semicolonToken;
    }

    public BreakStatementTreeImpl(IdentifierTree label, SyntaxToken semicolonToken) {
        this.label = label;
        this.semicolonToken = semicolonToken;
    }

    public BreakStatementTreeImpl complete(InternalSyntaxToken breakKeyword) {
        Preconditions.checkState((this.breakKeyword == null ? 1 : 0) != 0, (Object)"Already completed");
        this.breakKeyword = breakKeyword;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BREAK_STATEMENT;
    }

    @Override
    public SyntaxToken breakKeyword() {
        return this.breakKeyword;
    }

    @Override
    @Nullable
    public IdentifierTree label() {
        return this.label;
    }

    @Override
    @Nullable
    public SyntaxToken semicolonToken() {
        return this.semicolonToken;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.breakKeyword, this.label, this.semicolonToken});
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitBreakStatement(this);
    }
}

