/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;

public class AngularJS {
    private static final Set<String> MODULE_METHODS = ImmutableSet.of((Object)"provider", (Object)"factory", (Object)"service", (Object)"value", (Object)"constant", (Object)"decorator", (Object[])new String[]{"animation", "filter", "controller", "directive", "component", "config", "run"});

    private AngularJS() {
    }

    @CheckForNull
    public static boolean isModule(CallExpressionTree tree) {
        if (tree.callee().is(Tree.Kind.DOT_MEMBER_EXPRESSION)) {
            MemberExpressionTree callee = (MemberExpressionTree)tree.callee();
            return AngularJS.isAngularModule(callee) || AngularJS.isAngularModuleMethod(callee);
        }
        return false;
    }

    private static boolean isAngularModule(MemberExpressionTree tree) {
        return "angular".equals(AngularJS.getIdentifierName(tree.object())) && "module".equals(AngularJS.getIdentifierName(tree.property()));
    }

    private static boolean isAngularModuleMethod(MemberExpressionTree tree) {
        return tree.object().types().contains(Type.Kind.ANGULAR_MODULE) && MODULE_METHODS.contains(AngularJS.getIdentifierName(tree.property()));
    }

    private static String getIdentifierName(ExpressionTree tree) {
        if (tree.is(Tree.Kind.IDENTIFIER_NAME, Tree.Kind.IDENTIFIER_REFERENCE)) {
            return ((IdentifierTree)tree).name();
        }
        return null;
    }
}

