/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.visitors;

import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

public class IssueLocation {
    private final SyntaxToken firstToken;
    private final SyntaxToken lastToken;
    private final String message;
    private int lastTokenLinesNumber = 1;
    private int lastTokenLastLineLength = 0;

    public IssueLocation(Tree tree, @Nullable String message) {
        this(tree, tree, message);
    }

    public IssueLocation(Tree firstTree, Tree lastTree, @Nullable String message) {
        this.firstToken = ((JavaScriptTree)firstTree).getFirstToken();
        this.lastToken = ((JavaScriptTree)lastTree).getLastToken();
        this.message = message;
        this.calculateLastTokenLines();
    }

    private void calculateLastTokenLines() {
        String text = this.lastToken.text();
        if (text.startsWith("\"") || text.startsWith("'") || text.startsWith("`")) {
            String[] split = text.split("\n");
            this.lastTokenLinesNumber = split.length;
            this.lastTokenLastLineLength = split[split.length - 1].length();
        }
    }

    public IssueLocation(Tree tree) {
        this(tree, null);
    }

    @Nullable
    public String message() {
        return this.message;
    }

    public int startLine() {
        return this.firstToken.line();
    }

    public int startLineOffset() {
        return this.firstToken.column();
    }

    public int endLine() {
        return this.lastToken.line() + this.lastTokenLinesNumber - 1;
    }

    public int endLineOffset() {
        if (this.lastTokenLinesNumber == 1) {
            return this.lastToken.column() + this.lastToken.text().length();
        }
        return this.lastTokenLastLineLength;
    }
}

