/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.highlighter;

import java.util.HashSet;
import java.util.LinkedList;
import org.sonar.api.batch.sensor.symbol.NewSymbol;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.javascript.tree.symbols.type.ClassType;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierListTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxJavaScriptExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxSpreadAttributeTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public class HighlightSymbolTableBuilder {
    private HighlightSymbolTableBuilder() {
    }

    public static void build(NewSymbolTable newSymbolTable, TreeVisitorContext context) {
        HashSet<ClassType> classTypes = new HashSet<ClassType>();
        for (Symbol symbol : context.getSymbolModel().getSymbols()) {
            Type classType;
            HighlightSymbolTableBuilder.highlightSymbol(newSymbolTable, symbol);
            if (symbol.kind() != Symbol.Kind.CLASS || (classType = symbol.types().getUniqueType(Type.Kind.CLASS)) == null) continue;
            classTypes.add((ClassType)classType);
        }
        for (ClassType classType : classTypes) {
            for (Symbol symbol : classType.properties()) {
                HighlightSymbolTableBuilder.highlightSymbol(newSymbolTable, symbol);
            }
        }
        new BracesVisitor(newSymbolTable).scanTree(context);
        newSymbolTable.save();
    }

    private static void highlightSymbol(NewSymbolTable newSymbolTable, Symbol symbol) {
        if (!symbol.usages().isEmpty()) {
            LinkedList<Usage> usagesList = new LinkedList<Usage>(symbol.usages());
            SyntaxToken token = ((Usage)usagesList.get(0)).identifierTree().identifierToken();
            NewSymbol newSymbol = HighlightSymbolTableBuilder.getHighlightedSymbol(newSymbolTable, token);
            for (int i = 1; i < usagesList.size(); ++i) {
                SyntaxToken referenceToken = HighlightSymbolTableBuilder.getToken(((Usage)usagesList.get(i)).identifierTree());
                HighlightSymbolTableBuilder.addReference(newSymbol, referenceToken);
            }
        }
    }

    private static void addReference(NewSymbol symbol, SyntaxToken referenceToken) {
        symbol.newReference(referenceToken.line(), referenceToken.column(), referenceToken.line(), referenceToken.column() + referenceToken.text().length());
    }

    private static NewSymbol getHighlightedSymbol(NewSymbolTable newSymbolTable, SyntaxToken token) {
        return newSymbolTable.newSymbol(token.line(), token.column(), token.line(), token.column() + token.text().length());
    }

    private static SyntaxToken getToken(IdentifierTree identifierTree) {
        return identifierTree.identifierToken();
    }

    private static class BracesVisitor
    extends DoubleDispatchVisitor {
        private final NewSymbolTable newSymbolTable;

        BracesVisitor(NewSymbolTable newSymbolTable) {
            this.newSymbolTable = newSymbolTable;
        }

        @Override
        public void visitBlock(BlockTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitBlock(tree);
        }

        @Override
        public void visitObjectLiteral(ObjectLiteralTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitObjectLiteral(tree);
        }

        @Override
        public void visitClass(ClassTree tree) {
            this.highlightBraces(tree.openCurlyBraceToken(), tree.closeCurlyBraceToken());
            super.visitClass(tree);
        }

        @Override
        public void visitTemplateExpression(TemplateExpressionTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitTemplateExpression(tree);
        }

        @Override
        public void visitSpecifierList(SpecifierListTree tree) {
            this.highlightBraces(tree.openCurlyBraceToken(), tree.closeCurlyBraceToken());
            super.visitSpecifierList(tree);
        }

        @Override
        public void visitObjectBindingPattern(ObjectBindingPatternTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitObjectBindingPattern(tree);
        }

        @Override
        public void visitJsxSpreadAttribute(JsxSpreadAttributeTree tree) {
            this.highlightBraces(tree.lCurlyBraceToken(), tree.rCurlyBraceToken());
            super.visitJsxSpreadAttribute(tree);
        }

        @Override
        public void visitJsxJavaScriptExpression(JsxJavaScriptExpressionTree tree) {
            this.highlightBraces(tree.lCurlyBraceToken(), tree.rCurlyBraceToken());
            super.visitJsxJavaScriptExpression(tree);
        }

        @Override
        public void visitSwitchStatement(SwitchStatementTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitSwitchStatement(tree);
        }

        private void highlightBraces(SyntaxToken left, SyntaxToken right) {
            NewSymbol symbol = HighlightSymbolTableBuilder.getHighlightedSymbol(this.newSymbolTable, left);
            HighlightSymbolTableBuilder.addReference(symbol, right);
        }
    }
}

