/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.ce.measure.RangeDistributionBuilder;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.javascript.metrics.CommentLineVisitor;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.metrics.CounterVisitor;
import org.sonar.javascript.metrics.LineVisitor;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public class MetricsVisitor
extends SubscriptionVisitor {
    private static final Number[] LIMITS_COMPLEXITY_FUNCTIONS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private static final Tree.Kind[] CLASS_NODES = new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION};
    private final FileSystem fs;
    private final SensorContext sensorContext;
    private InputFile inputFile;
    private NoSonarFilter noSonarFilter;
    private final Boolean ignoreHeaderComments;
    private FileLinesContextFactory fileLinesContextFactory;
    private Map<InputFile, Set<Integer>> projectLinesOfCode;
    private int classComplexity;
    private int functionComplexity;
    private RangeDistributionBuilder functionComplexityDistribution;
    private RangeDistributionBuilder fileComplexityDistribution;
    private ComplexityVisitor complexityVisitor;

    public MetricsVisitor(FileSystem fs, SensorContext context, NoSonarFilter noSonarFilter, Boolean ignoreHeaderComments, FileLinesContextFactory fileLinesContextFactory, Map<InputFile, Set<Integer>> projectLinesOfCode) {
        this.fs = fs;
        this.sensorContext = context;
        this.noSonarFilter = noSonarFilter;
        this.ignoreHeaderComments = ignoreHeaderComments;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.complexityVisitor = new ComplexityVisitor();
        this.projectLinesOfCode = projectLinesOfCode;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> result = new ArrayList<Tree.Kind>(TreeKinds.functionKinds());
        result.addAll(Arrays.asList(CLASS_NODES));
        return result;
    }

    @Override
    public void leaveFile(Tree scriptTree) {
        this.saveComplexityMetrics(this.getContext());
        this.saveCounterMetrics(this.getContext());
        this.saveLineMetrics(this.getContext());
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(CLASS_NODES)) {
            this.classComplexity += this.complexityVisitor.getComplexity(tree);
        } else if (TreeKinds.isFunction(tree)) {
            int currentFunctionComplexity = this.complexityVisitor.getComplexity(tree);
            this.functionComplexity += currentFunctionComplexity;
            this.functionComplexityDistribution.add((Number)currentFunctionComplexity);
        }
    }

    @Override
    public void visitFile(Tree scriptTree) {
        this.inputFile = this.fs.inputFile(this.fs.predicates().is(this.getContext().getFile()));
        this.init();
    }

    private void init() {
        this.classComplexity = 0;
        this.functionComplexity = 0;
        this.functionComplexityDistribution = new RangeDistributionBuilder(LIMITS_COMPLEXITY_FUNCTIONS);
        this.fileComplexityDistribution = new RangeDistributionBuilder(FILES_DISTRIB_BOTTOM_LIMITS);
    }

    private void saveCounterMetrics(TreeVisitorContext context) {
        CounterVisitor counter = new CounterVisitor(context.getTopTree());
        this.saveMetricOnFile(CoreMetrics.FUNCTIONS, counter.getFunctionNumber());
        this.saveMetricOnFile(CoreMetrics.STATEMENTS, counter.getStatementsNumber());
        this.saveMetricOnFile(CoreMetrics.CLASSES, counter.getClassNumber());
    }

    private void saveComplexityMetrics(TreeVisitorContext context) {
        int fileComplexity = this.complexityVisitor.getComplexity(context.getTopTree());
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY, fileComplexity);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY_IN_CLASSES, this.classComplexity);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY_IN_FUNCTIONS, this.functionComplexity);
        this.sensorContext.newMeasure().on((InputComponent)this.inputFile).forMetric((Metric)CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION).withValue((Serializable)((Object)this.functionComplexityDistribution.build())).save();
        this.fileComplexityDistribution.add((Number)fileComplexity);
        this.sensorContext.newMeasure().on((InputComponent)this.inputFile).forMetric((Metric)CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION).withValue((Serializable)((Object)this.fileComplexityDistribution.build())).save();
    }

    private void saveLineMetrics(TreeVisitorContext context) {
        LineVisitor lineVisitor = new LineVisitor(context.getTopTree());
        int linesNumber = lineVisitor.getLinesNumber();
        Set<Integer> linesOfCode = lineVisitor.getLinesOfCode();
        this.projectLinesOfCode.put(this.inputFile, linesOfCode);
        this.saveMetricOnFile(CoreMetrics.NCLOC, lineVisitor.getLinesOfCodeNumber());
        CommentLineVisitor commentVisitor = new CommentLineVisitor(context.getTopTree(), this.ignoreHeaderComments);
        Set<Integer> commentLines = commentVisitor.getCommentLines();
        this.saveMetricOnFile(CoreMetrics.COMMENT_LINES, commentVisitor.getCommentLineNumber());
        this.noSonarFilter.noSonarInFile(this.inputFile, commentVisitor.noSonarLines());
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(this.inputFile);
        for (int line = 1; line <= linesNumber; ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, linesOfCode.contains(line) ? 1 : 0);
            fileLinesContext.setIntValue("comment_lines_data", line, commentLines.contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
    }

    private <T extends Serializable> void saveMetricOnFile(org.sonar.api.measures.Metric metric, T value) {
        this.sensorContext.newMeasure().withValue(value).forMetric((Metric)metric).on((InputComponent)this.inputFile).save();
    }

    public static Tree.Kind[] getClassNodes() {
        return CLASS_NODES;
    }
}

