/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.LogicalNotSymbolicValue;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.TypeOfComparisonSymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;

public class EqualToSymbolicValue
implements SymbolicValue {
    private static final Map<SpecialSymbolicValue, Constraint> EQUAL_CONSTRAINTS = ImmutableMap.of((Object)SpecialSymbolicValue.NULL, (Object)((Object)Constraint.NULL_OR_UNDEFINED), (Object)SpecialSymbolicValue.UNDEFINED, (Object)((Object)Constraint.NULL_OR_UNDEFINED));
    private static final Map<SpecialSymbolicValue, Constraint> NOT_EQUAL_CONSTRAINTS = ImmutableMap.of((Object)SpecialSymbolicValue.NULL, (Object)((Object)Constraint.NOT_NULLY), (Object)SpecialSymbolicValue.UNDEFINED, (Object)((Object)Constraint.NOT_NULLY));
    private static final Map<SpecialSymbolicValue, Constraint> STRICT_EQUAL_CONSTRAINTS = ImmutableMap.of((Object)SpecialSymbolicValue.NULL, (Object)((Object)Constraint.NULL), (Object)SpecialSymbolicValue.UNDEFINED, (Object)((Object)Constraint.UNDEFINED));
    private static final Map<SpecialSymbolicValue, Constraint> STRICT_NOT_EQUAL_CONSTRAINTS = ImmutableMap.of((Object)SpecialSymbolicValue.NULL, (Object)((Object)Constraint.NOT_NULL), (Object)SpecialSymbolicValue.UNDEFINED, (Object)((Object)Constraint.NOT_UNDEFINED));
    private final SymbolicValue firstOperandValue;
    private final Constraint secondOperandConstraint;

    public EqualToSymbolicValue(SymbolicValue firstOperandValue, Constraint constraint) {
        Preconditions.checkArgument((firstOperandValue != null ? 1 : 0) != 0, (Object)"operandValue should not be null");
        this.firstOperandValue = firstOperandValue;
        this.secondOperandConstraint = constraint;
    }

    public static SymbolicValue createEqual(SymbolicValue operand1, SymbolicValue operand2) {
        return EqualToSymbolicValue.create(EQUAL_CONSTRAINTS, operand1, operand2, false);
    }

    public static SymbolicValue createNotEqual(SymbolicValue operand1, SymbolicValue operand2) {
        return EqualToSymbolicValue.create(NOT_EQUAL_CONSTRAINTS, operand1, operand2, true);
    }

    public static SymbolicValue createStrictEqual(SymbolicValue operand1, SymbolicValue operand2) {
        return EqualToSymbolicValue.create(STRICT_EQUAL_CONSTRAINTS, operand1, operand2, false);
    }

    public static SymbolicValue createStrictNotEqual(SymbolicValue operand1, SymbolicValue operand2) {
        return EqualToSymbolicValue.create(STRICT_NOT_EQUAL_CONSTRAINTS, operand1, operand2, true);
    }

    private static SymbolicValue create(Map<SpecialSymbolicValue, Constraint> map, SymbolicValue operand1, SymbolicValue operand2, boolean isLogicalNot) {
        Constraint constraint = map.get(operand1);
        if (constraint != null && operand2 != null) {
            return new EqualToSymbolicValue(operand2, constraint);
        }
        constraint = map.get(operand2);
        if (constraint != null && operand1 != null) {
            return new EqualToSymbolicValue(operand1, constraint);
        }
        SymbolicValue typeOfComparison = TypeOfComparisonSymbolicValue.create(operand1, operand2);
        if (typeOfComparison != null) {
            if (isLogicalNot) {
                typeOfComparison = LogicalNotSymbolicValue.create(typeOfComparison);
            }
            return typeOfComparison;
        }
        return UnknownSymbolicValue.UNKNOWN;
    }

    @Override
    public List<ProgramState> constrain(ProgramState state, Constraint constraint) {
        if (constraint.equals((Object)Constraint.TRUTHY)) {
            return this.firstOperandValue.constrain(state, this.secondOperandConstraint);
        }
        if (constraint.equals((Object)Constraint.FALSY)) {
            return this.firstOperandValue.constrain(state, this.secondOperandConstraint.not());
        }
        return ImmutableList.of();
    }

    @Override
    public Constraint inherentConstraint() {
        return this.secondOperandConstraint;
    }

    public String toString() {
        return this.firstOperandValue + " === " + (Object)((Object)this.secondOperandConstraint);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.firstOperandValue, this.secondOperandConstraint});
    }

    public boolean equals(Object obj) {
        if (obj instanceof EqualToSymbolicValue) {
            EqualToSymbolicValue other = (EqualToSymbolicValue)obj;
            return Objects.equals(this.firstOperandValue, other.firstOperandValue) && Objects.equals((Object)this.secondOperandConstraint, (Object)other.secondOperandConstraint);
        }
        return false;
    }
}

