/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;

public class LiteralSymbolicValue
implements SymbolicValue {
    private final LiteralTree literal;

    private LiteralSymbolicValue(LiteralTree literal) {
        this.literal = literal;
    }

    public static LiteralSymbolicValue get(LiteralTree literal) {
        return new LiteralSymbolicValue(literal);
    }

    public LiteralTree getLiteral() {
        return this.literal;
    }

    @Override
    public List<ProgramState> constrain(ProgramState state, Constraint constraint) {
        if (this.inherentConstraint().isIncompatibleWith(constraint)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)state);
    }

    @Override
    public Constraint inherentConstraint() {
        return this.isTruthy() ? Constraint.TRUTHY : Constraint.FALSY_NOT_NULLY;
    }

    private boolean isTruthy() {
        if (this.literal.is(Tree.Kind.BOOLEAN_LITERAL)) {
            return "true".equals(this.literal.value());
        }
        if (this.literal.is(Tree.Kind.STRING_LITERAL)) {
            return this.literal.value().length() > 2;
        }
        if (this.literal.is(Tree.Kind.NUMERIC_LITERAL)) {
            return this.isTruthyNumeric();
        }
        throw new IllegalStateException("Unknown literal: " + this.literal);
    }

    private boolean isTruthyNumeric() {
        String stringValue = this.literal.value();
        if (stringValue.startsWith("0x") || stringValue.startsWith("0b") || stringValue.startsWith("0o") || stringValue.startsWith("0O")) {
            return LiteralSymbolicValue.hasNonZero(stringValue.substring(2));
        }
        int exponentIndex = stringValue.indexOf(101);
        if (exponentIndex == -1) {
            exponentIndex = stringValue.indexOf(69);
        }
        if (exponentIndex > -1) {
            stringValue = stringValue.substring(0, exponentIndex);
        }
        return LiteralSymbolicValue.hasNonZero(stringValue);
    }

    private static boolean hasNonZero(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '0' || c == '.') continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "LiteralSV " + this.literal.value();
    }
}

